/*
 * Created on Jul 18, 2007
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.watchpoint.studio.validation.rules.template.graph;

import java.util.ArrayList;
import java.util.List;

import org.jbpm.gd.jpdl.model.Decision;
import org.jbpm.gd.jpdl.model.Fork;
import org.jbpm.gd.jpdl.model.Join;
import org.jbpm.gd.jpdl.model.NodeElement;
import org.jbpm.gd.jpdl.model.ProcessState;
import org.jbpm.gd.jpdl.model.StartState;

import com.tandbergtv.watchpoint.studio.ui.model.AssignNode;
import com.tandbergtv.watchpoint.studio.ui.model.AutomaticTaskNode;
import com.tandbergtv.watchpoint.studio.ui.model.LoopNode;
import com.tandbergtv.watchpoint.studio.ui.model.MailNode;
import com.tandbergtv.watchpoint.studio.ui.model.ManualTaskNode;
import com.tandbergtv.watchpoint.studio.ui.model.NodeDefinition;
import com.tandbergtv.watchpoint.studio.ui.model.WPEndState;
import com.tandbergtv.watchpoint.studio.validation.graph.WorkflowTemplateGraph;
import com.tandbergtv.watchpoint.studio.validation.rules.nodeelementcontainer.graph.AllowedNodeTypesRule;

/**
 * Validates the types of the Nodes that are present in the Template.
 * 
 * @author Vijay Silva
 */
public class AllowedTemplateNodeTypesRule extends AllowedNodeTypesRule<WorkflowTemplateGraph>
{
	/**
	 * @see com.tandbergtv.watchpoint.studio.validation.rules.nodeelementcontainer.graph.AllowedNodeTypesRule#getAllowedNodeTypes()
	 */
	@Override
	protected List<Class<? extends NodeElement>> getAllowedNodeTypes()
	{
		List<Class<? extends NodeElement>> allowedTypes = new ArrayList<Class<? extends NodeElement>>();

		allowedTypes.add(StartState.class);
		allowedTypes.add(WPEndState.class);
		allowedTypes.add(Decision.class);
		allowedTypes.add(NodeDefinition.class);
		allowedTypes.add(AutomaticTaskNode.class);
		allowedTypes.add(ManualTaskNode.class);
		allowedTypes.add(Fork.class);
		allowedTypes.add(Join.class);
		allowedTypes.add(ProcessState.class);
		allowedTypes.add(MailNode.class);
		allowedTypes.add(LoopNode.class);
		allowedTypes.add(AssignNode.class);
		return allowedTypes;
	}
}
