/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.debugger.runtime;

import com.tandbergtv.watchpoint.studio.debugger.core.graph.Loop2;
import com.tandbergtv.watchpoint.studio.debugger.core.graph.exe.ExecutionContext2;
import com.tandbergtv.watchpoint.studio.debugger.model.NodeSimulationConfig;
import com.tandbergtv.watchpoint.studio.debugger.model.SimulationType;
import com.tandbergtv.watchpoint.studio.debugger.runtime.TemplateSimulator;
import com.tandbergtv.watchpoint.studio.debugger.runtime.output.TemplateSimulationOutputWriter;
import java.util.Map;
import java.util.Stack;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.graph.def.Transition;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.graph.node.Fork;
import org.jbpm.graph.node.Join;

public class RecursiveTemplateSimulator
extends TemplateSimulator {
    private Stack<Integer> forkState = new Stack();
    private ExecutionContext executionContext;
    private TemplateSimulationOutputWriter writer;
    private Loop2 loop;
    private boolean hasFailed = false;

    public RecursiveTemplateSimulator(ProcessDefinition template, Map<String, NodeSimulationConfig> simulationConfigMap, TemplateSimulationOutputWriter writer) {
        super(template, simulationConfigMap);
        this.writer = writer;
    }

    /*
     * Unable to fully structure code
     */
    public void runNode(Node node) {
        block14: {
            nodeSimulator = this.simulatorFactory.getSimulatorFor(node);
            this.writer.nodeSimulationStarted(this.executionContext, node, nodeSimulator);
            if (nodeSimulator != null) {
                if (!SimulationType.SKIP_NODE.equals((Object)nodeSimulator.getSimulationConfig().getSimulationType())) {
                    nodeSimulator.startSimulation(this.executionContext);
                }
                this.hasFailed = nodeSimulator.fail();
            }
            this.writer.nodeSimulationCompleted(this.executionContext, node, nodeSimulator);
            if (this.hasFailed) {
                return;
            }
            if (node instanceof Join) {
                currentForkState = this.forkState.pop();
                if (--currentForkState > 0) {
                    this.forkState.push(currentForkState);
                    return;
                }
            } else if (node instanceof Fork) {
                this.forkState.push(node.getLeavingTransitions().size());
            }
            if (node instanceof Loop2) {
                this.loop = (Loop2)node;
            } else if (this.loop != null && !this.loop.evaluateExpression(this.executionContext)) {
                return;
            }
            transitions = null;
            transitions = nodeSimulator != null ? nodeSimulator.getLeavingTransitions() : node.getLeavingTransitions();
            if (transitions == null) break block14;
            for (E obj : transitions) {
                transition = (Transition)obj;
                if (transition.getTo() == null) continue;
                if (this.hasFailed) {
                    return;
                }
                if (node == this.loop) ** GOTO lbl42
                this.runNode(transition.getTo());
                continue;
lbl-1000:
                // 1 sources

                {
                    this.runNode(transition.getTo());
                    if (this.hasFailed) {
                        return;
                    }
                    this.writer.nodeSimulationStarted(this.executionContext, node, nodeSimulator);
                    this.loop.incrementIndex(this.executionContext);
                    this.writer.nodeSimulationCompleted(this.executionContext, node, nodeSimulator);
lbl42:
                    // 2 sources

                    ** while (this.loop.evaluateExpression((ExecutionContext)this.executionContext))
                }
lbl43:
                // 1 sources

                this.loop = null;
                loopExit = (Transition)node.getLeavingTransitions().get(0);
                this.runNode(loopExit.getTo());
            }
        }
    }

    @Override
    public void startSimulation() {
        ProcessInstance processInstance = new ProcessInstance(this.template);
        this.executionContext = new ExecutionContext2(processInstance.getRootToken());
        this.writer.templateSimulationStarted(this.executionContext, this.template);
        Node currentNode = this.template.getStartState();
        this.runNode(currentNode);
        this.writer.templateSimulationCompleted(this.executionContext, this.template);
    }
}

