/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.debugger.runtime.nodesimulation;

import com.tandbergtv.watchpoint.studio.debugger.core.DatatypeConverter;
import com.tandbergtv.watchpoint.studio.debugger.core.TypeConversionException;
import com.tandbergtv.watchpoint.studio.debugger.core.VariableAccess2;
import com.tandbergtv.watchpoint.studio.debugger.model.ParameterizableSimulationData;
import com.tandbergtv.watchpoint.studio.debugger.runtime.exception.NodeSimulationException;
import com.tandbergtv.watchpoint.studio.debugger.runtime.nodesimulation.AbstractMessageNodeSimulator;
import java.util.Collection;
import java.util.Collections;
import org.jbpm.context.def.VariableAccess;
import org.jbpm.graph.node.StartState;

public class StartStateNodeSimulator
extends AbstractMessageNodeSimulator {
    protected Collection<VariableAccess> variables = null;

    @Override
    public void simulate() throws Exception {
        ParameterizableSimulationData simulationData = this.getSimulationData();
        DatatypeConverter converter = new DatatypeConverter();
        for (VariableAccess var : this.getVariables()) {
            VariableAccess2 taskVar = (VariableAccess2)var;
            Object value = null;
            try {
                Object storedValue = simulationData.getVariable(var.getVariableName());
                if (storedValue != null && !"".equals(storedValue)) {
                    value = converter.convert(storedValue, taskVar.getDatatype());
                }
            }
            catch (TypeConversionException e) {
                String msg = "Error converting types. Please, verify the data type for the variable: " + var.getVariableName();
                throw new NodeSimulationException(msg, this.node, this, e);
            }
            this.executionContext.setVariable(var.getVariableName(), value);
        }
    }

    @Override
    public Collection<VariableAccess> getVariables() {
        if (this.variables == null) {
            StartState startState = (StartState)this.node;
            this.variables = Collections.emptyList();
            if (startState.getProcessDefinition().getTaskMgmtDefinition().getStartTask() != null) {
                this.variables = startState.getProcessDefinition().getTaskMgmtDefinition().getStartTask().getTaskController().getVariableAccesses();
            }
        }
        return this.variables;
    }
}

