/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.debugger.runtime.nodesimulation;

import com.tandbergtv.watchpoint.studio.debugger.core.graph.SuperState2;
import com.tandbergtv.watchpoint.studio.debugger.runtime.nodesimulation.AbstractMessageNodeSimulator;
import com.tandbergtv.workflow.core.graph.Loop;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jbpm.context.def.VariableAccess;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.def.SuperState;
import org.jbpm.graph.def.Transition;
import org.jbpm.graph.node.TaskNode;
import org.jbpm.taskmgmt.def.Task;

public class SuperStateNodeSimulator
extends AbstractMessageNodeSimulator {
    protected Collection<VariableAccess> variables = null;

    public List<Transition> getLeavingTransitions() {
        SuperState2 superState = (SuperState2)this.node;
        ArrayList<Transition> leavingTransitions = new ArrayList<Transition>();
        if (superState.getLeavingTransitions() != null && !superState.getLeavingTransitions().isEmpty()) {
            leavingTransitions.add((Transition)superState.getLeavingTransitions().get(superState.getLeavingTransitions().size() - 1));
        }
        return leavingTransitions;
    }

    public void fillInnerNodeVariables(Node childNode, Map<String, VariableAccess> varMap) {
        Task task = null;
        task = childNode instanceof TaskNode ? ((TaskNode)childNode).getTask(childNode.getName()) : this.node.getProcessDefinition().getTaskMgmtDefinition().getTask(childNode.getName());
        if (task != null) {
            for (Object variable : task.getTaskController().getVariableAccesses()) {
                VariableAccess var = (VariableAccess)variable;
                if (varMap.containsKey(var.getVariableName())) continue;
                VariableAccess newVar = new VariableAccess(var.getVariableName(), var.getAccess().toString(), var.getMappedName());
                varMap.put(newVar.getVariableName(), newVar);
            }
        }
    }

    @Override
    public Collection<VariableAccess> getVariables() {
        if (this.variables == null) {
            HashMap<String, VariableAccess> varMap = new HashMap<String, VariableAccess>();
            SuperState superState = (SuperState)this.node;
            for (Object obj : superState.getNodes()) {
                Node childNode = (Node)Node.class.cast(obj);
                if (childNode instanceof Loop) {
                    Loop loop = (Loop)childNode;
                    for (Object loopNode : loop.getNodes()) {
                        this.fillInnerNodeVariables((Node)loopNode, varMap);
                    }
                    continue;
                }
                this.fillInnerNodeVariables(childNode, varMap);
            }
            this.variables = varMap.values();
        }
        return this.variables;
    }
}

