/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.debugger.ui;

import com.tandbergtv.watchpoint.studio.debugger.model.NodeSimulationConfig;
import com.tandbergtv.watchpoint.studio.debugger.model.SimulationType;
import com.tandbergtv.watchpoint.studio.debugger.ui.NodeSimulationTableComparator;
import com.tandbergtv.watchpoint.studio.debugger.ui.NodeSimulationTableLabelProvider;
import com.tandbergtv.watchpoint.studio.debugger.ui.SimulationModifyListener;
import com.tandbergtv.watchpoint.studio.ui.model.AutomaticTaskNode;
import com.tandbergtv.watchpoint.studio.ui.model.LoopNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.jbpm.gd.jpdl.model.Decision;

public class NodeSimulationTable {
    private Table table;
    private TableViewer tableViewer;
    protected String lastSortedColumn;
    protected boolean sortDesc;
    private List<SimulationModifyListener> simulationModifyListeners = new ArrayList<SimulationModifyListener>();
    private List<Button> skipButtons = new ArrayList<Button>();
    public static final String NODE_TYPE_COLUMN = "node_type";
    public static final String NODE_NAME_COLUMN = "name";
    public static final String NODE_DATA_COLUMN = "data";
    public static final String SKIP_COLUMN = "skip";
    public static final String SIMULATION_TYPE_COLUMN = "simulation_type";
    public static final String[] COLUMN_NAMES = new String[]{"node_type", "name", "data", "simulation_type", "skip"};

    public NodeSimulationTable(Composite parent) {
        this.createControls(parent);
    }

    private void createControls(Composite composite) {
        GridData gridData = new GridData(1808);
        composite.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 4;
        composite.setLayout((Layout)layout);
        this.createTable(composite);
        this.createTableViewer();
    }

    public void setSimulationData(Collection<NodeSimulationConfig> nodeSimulationData) {
        this.tableViewer.setInput(nodeSimulationData);
        this.createSkipColunnEditor();
    }

    public void createSkipColunnEditor() {
        Collection nodeSimulationData = (Collection)this.tableViewer.getInput();
        for (Button btn : this.skipButtons) {
            btn.dispose();
        }
        int i = 0;
        this.skipButtons = new ArrayList<Button>(nodeSimulationData.size());
        for (NodeSimulationConfig node : nodeSimulationData) {
            TableEditor checkboxEditor = new TableEditor(this.table);
            Button result = new Button((Composite)this.table, 32);
            result.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    Button btn = (Button)e.getSource();
                    NodeSimulationConfig node = (NodeSimulationConfig)btn.getData();
                    if (btn.getSelection()) {
                        node.setSimulationType(SimulationType.SKIP_NODE);
                    } else if (node.getNodeElement() instanceof AutomaticTaskNode || node.getNodeElement() instanceof LoopNode) {
                        node.setSimulationType(SimulationType.EXECUTE);
                    } else {
                        node.setSimulationType(SimulationType.SIMULATED_VALUES);
                    }
                    NodeSimulationTable.this.tableViewer.update((Object)node, null);
                    NodeSimulationTable.this.fireSimulationModifyListener(node);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            result.pack();
            checkboxEditor.minimumWidth = result.getSize().x;
            checkboxEditor.horizontalAlignment = 0x1000000;
            checkboxEditor.setEditor((Control)result, this.table.getItem(i), 4);
            if (node.getNodeElement() instanceof Decision) {
                result.setVisible(false);
            }
            result.setData((Object)node);
            result.setSelection(SimulationType.SKIP_NODE.equals((Object)node.getSimulationType()));
            this.skipButtons.add(result);
            ++i;
        }
    }

    public void refreshSkipColumn() {
        int i = 0;
        TableItem[] tableItemArray = this.table.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            NodeSimulationConfig node = (NodeSimulationConfig)item.getData();
            Button btn = this.skipButtons.get(i);
            if (node.getNodeElement() instanceof Decision) {
                btn.setVisible(false);
            } else {
                btn.setVisible(true);
            }
            btn.setData((Object)node);
            btn.setSelection(SimulationType.SKIP_NODE.equals((Object)node.getSimulationType()));
            ++i;
            ++n2;
        }
    }

    private void createTable(Composite parent) {
        int style = 101124;
        this.table = new Table(parent, style);
        GridData gridData = new GridData(1808);
        gridData.grabExcessVerticalSpace = true;
        this.table.setLayoutData((Object)gridData);
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        TableColumn column = new TableColumn(this.table, 16384, 0);
        column.setText("Node Type");
        column.setWidth(150);
        column.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NodeSimulationTable.this.sortTable(NodeSimulationTable.NODE_TYPE_COLUMN);
            }
        });
        column = new TableColumn(this.table, 16384, 1);
        column.setText("Node Name");
        column.setWidth(150);
        column.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NodeSimulationTable.this.sortTable(NodeSimulationTable.NODE_NAME_COLUMN);
            }
        });
        column = new TableColumn(this.table, 16384, 2);
        column.setText("Node Data");
        column.setWidth(300);
        column.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NodeSimulationTable.this.sortTable(NodeSimulationTable.NODE_DATA_COLUMN);
            }
        });
        column = new TableColumn(this.table, 16384, 3);
        column.setText("Simulation Type");
        column.setWidth(100);
        column.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NodeSimulationTable.this.sortTable(NodeSimulationTable.SIMULATION_TYPE_COLUMN);
            }
        });
        column = new TableColumn(this.table, 0x1000000, 4);
        column.setText("Skip");
        column.setWidth(50);
    }

    protected void sortTable(String column) {
        this.sortDesc = column.equals(this.lastSortedColumn) ? !this.sortDesc : false;
        NodeSimulationTableComparator comparator = new NodeSimulationTableComparator(column, this.sortDesc);
        this.tableViewer.setComparator((ViewerComparator)comparator);
        this.lastSortedColumn = column;
        this.refreshSkipColumn();
    }

    private void createTableViewer() {
        this.tableViewer = new TableViewer(this.table);
        this.tableViewer.setUseHashlookup(true);
        this.tableViewer.setColumnProperties(COLUMN_NAMES);
        CellEditor[] editors = new CellEditor[COLUMN_NAMES.length];
        editors[4] = new CheckboxCellEditor((Composite)this.table);
        this.tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new NodeSimulationTableLabelProvider());
    }

    public void close() {
        Shell shell = this.table.getShell();
        if (shell != null && !shell.isDisposed()) {
            shell.dispose();
        }
    }

    public List<String> getColumnNames() {
        return Arrays.asList(COLUMN_NAMES);
    }

    public NodeSimulationConfig getSelection() {
        NodeSimulationConfig config = null;
        TableItem[] selectedItems = this.table.getSelection();
        if (selectedItems.length > 0) {
            config = (NodeSimulationConfig)selectedItems[0].getData();
        }
        return config;
    }

    public Control getControl() {
        return this.table.getParent();
    }

    public void updateNode(NodeSimulationConfig node) {
        this.tableViewer.update((Object)node, null);
        for (Button button : this.skipButtons) {
            NodeSimulationConfig buttonNode = (NodeSimulationConfig)button.getData();
            if (!buttonNode.getTemplateNodeName().equals(node.getTemplateNodeName())) continue;
            button.setSelection(SimulationType.SKIP_NODE.equals((Object)node.getSimulationType()));
        }
    }

    public void fireSimulationModifyListener(Object o) {
        for (SimulationModifyListener listener : this.simulationModifyListeners) {
            listener.modifySimulation(o);
        }
    }

    public void addSelectionListener(SelectionListener listener) {
        this.table.addSelectionListener(listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.table.removeSelectionListener(listener);
    }

    public void dispose() {
        this.tableViewer.getLabelProvider().dispose();
    }

    public void addSimulationModifyListener(SimulationModifyListener listener) {
        this.simulationModifyListeners.add(listener);
    }
}

