/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.debugger.ui;

import com.tandbergtv.watchpoint.studio.debugger.model.NodeSimulationConfig;
import com.tandbergtv.watchpoint.studio.debugger.model.ParameterizableSimulationData;
import com.tandbergtv.watchpoint.studio.debugger.model.SimulationType;
import com.tandbergtv.watchpoint.studio.debugger.ui.AbstractNodeSimulationComposite;
import com.tandbergtv.watchpoint.studio.debugger.ui.SimulationModifyListener;
import com.tandbergtv.watchpoint.studio.debugger.ui.VariableExpressionValuesTable;
import com.tandbergtv.watchpoint.studio.debugger.ui.VariableNameTableLabelProvider;
import com.tandbergtv.watchpoint.studio.ui.model.ManualTaskNode;
import com.tandbergtv.watchpoint.studio.ui.model.NodeDefinition;
import com.tandbergtv.watchpoint.studio.ui.model.NodeGroup;
import com.tandbergtv.watchpoint.studio.ui.model.WPVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Widget;
import org.jbpm.gd.jpdl.model.NodeElement;
import org.jbpm.gd.jpdl.model.ProcessState;
import org.jbpm.gd.jpdl.model.Variable;

public class ParameterizableNodeSimulationComposite
extends AbstractNodeSimulationComposite
implements SimulationModifyListener {
    protected VariableExpressionValuesTable variableValuesTable;
    protected Label lblReturnValues;
    protected Button btnFail;
    protected Label lblFail;
    private static final String SEMICOLON = ";";

    public ParameterizableNodeSimulationComposite(Composite parent, NodeSimulationConfig node) {
        super(parent, node);
    }

    @Override
    protected void createAdditionalControls(Composite parent) {
        this.createFailWidget(parent);
        this.createNodeSimulationTable(parent);
    }

    protected void createFailWidget(Composite composite) {
        this.lblFail = new Label(composite, 0);
        this.lblFail.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.lblFail.setText("Fail :");
        this.lblFail.setEnabled(false);
        this.btnFail = new Button(composite, 32);
        this.btnFail.setEnabled(false);
        this.btnFail.addSelectionListener((SelectionListener)this);
    }

    protected void createNodeSimulationTable(Composite composite) {
        this.lblReturnValues = new Label(composite, 0);
        this.lblReturnValues.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        this.lblReturnValues.setText("Return Values :");
        this.variableValuesTable = new VariableExpressionValuesTable(composite);
        this.variableValuesTable.addSimulationModifyListener(this);
    }

    @Override
    public void load(NodeSimulationConfig nodeSimulationConfig) {
        super.load(nodeSimulationConfig);
        this.updateWidgets();
        ParameterizableSimulationData simulationData = this.getSimulationData();
        this.btnFail.setSelection(simulationData.isFail());
        List<Variable> variables = Collections.emptyList();
        if (nodeSimulationConfig.getNodeElement() instanceof NodeDefinition) {
            NodeDefinition nd = (NodeDefinition)nodeSimulationConfig.getNodeElement();
            variables = new ArrayList(nd.getVariables());
            if (nd.getNode() instanceof NodeGroup) {
                this.variableValuesTable.setLabelProvider(new VariableNameTableLabelProvider());
                HashMap<String, Variable> mappedNameMap = new HashMap<String, Variable>(variables.size());
                for (Variable variable : variables) {
                    mappedNameMap.put(variable.getMappedName(), variable);
                }
                NodeGroup group = (NodeGroup)nd.getNode();
                NodeElement[] nodeElementArray = group.getNodeElements();
                int n = nodeElementArray.length;
                int n2 = 0;
                while (n2 < n) {
                    NodeElement ssElement = nodeElementArray[n2];
                    if (ssElement instanceof NodeDefinition) {
                        NodeDefinition ssNode = (NodeDefinition)ssElement;
                        for (WPVariable ssNodeVar : ssNode.getVariables()) {
                            Variable variable = (Variable)mappedNameMap.get(ssNodeVar.getName());
                            if (variable == null) continue;
                            variable.setAccess(ssNodeVar.getAccess());
                        }
                    }
                    ++n2;
                }
            }
        } else if (nodeSimulationConfig.getNodeElement() instanceof ProcessState) {
            ProcessState process = (ProcessState)nodeSimulationConfig.getNodeElement();
            variables = new ArrayList<Variable>(Arrays.asList(process.getVariables()));
        } else if (nodeSimulationConfig.getNodeElement() instanceof ManualTaskNode) {
            ManualTaskNode manual = (ManualTaskNode)nodeSimulationConfig.getNodeElement();
            variables = new ArrayList(manual.getVariables());
        }
        for (Variable var : variables) {
            WPVariable v = (WPVariable)var;
            if (v.getAccess().contains("write")) {
                v.setValue((String)simulationData.getVariable(v.getName()));
                continue;
            }
            v.setValue(v.getName());
        }
        this.variableValuesTable.setVariablesData(variables);
        if (this.template.getStartState().getTask() != null) {
            this.variableValuesTable.setContextVariables(Arrays.asList(this.template.getStartState().getTask().getController().getVariables()));
        }
        this.variableValuesTable.setProject(ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(nodeSimulationConfig.getTemplatePath())).getProject());
        this.variableValuesTable.initializeExpressionEditor();
    }

    protected void updateWidgets() {
        boolean isSimulatedValues = SimulationType.SIMULATED_VALUES.equals((Object)this.nodeSimulationConfig.getSimulationType());
        this.variableValuesTable.setEnabled(isSimulatedValues);
        this.lblReturnValues.setEnabled(isSimulatedValues);
        this.lblFail.setEnabled(isSimulatedValues);
        this.btnFail.setEnabled(isSimulatedValues);
    }

    @Override
    protected SimulationType[] getSimulationTypes() {
        return new SimulationType[]{SimulationType.SKIP_NODE, SimulationType.SIMULATED_VALUES};
    }

    @Override
    public void widgetSelected(SelectionEvent e) {
        Widget widget = (Widget)e.getSource();
        if (SimulationType.SIMULATED_VALUES.equals(widget.getData()) && !SimulationType.SIMULATED_VALUES.equals((Object)this.nodeSimulationConfig.getSimulationType())) {
            Button btn = (Button)widget;
            this.variableValuesTable.setEnabled(btn.getSelection());
            this.lblReturnValues.setEnabled(btn.getSelection());
            this.lblFail.setEnabled(btn.getSelection());
            this.btnFail.setEnabled(btn.getSelection());
            this.nodeSimulationConfig.setSimulationType(SimulationType.SIMULATED_VALUES);
            this.updateWidgets();
            this.fireSimulationModifiedEvent(this.nodeSimulationConfig);
        } else if (SimulationType.SKIP_NODE.equals(widget.getData())) {
            this.nodeSimulationConfig.setSimulationType(SimulationType.SKIP_NODE);
            this.updateWidgets();
            this.fireSimulationModifiedEvent(this.nodeSimulationConfig);
        } else if (widget == this.btnFail) {
            this.getSimulationData().setFail(this.btnFail.getSelection());
            this.fireSimulationModifiedEvent(this.nodeSimulationConfig);
        }
    }

    public ParameterizableSimulationData getSimulationData() {
        ParameterizableSimulationData result = null;
        result = !(this.nodeSimulationConfig.getSimulationData() instanceof ParameterizableSimulationData) ? new ParameterizableSimulationData(this.nodeSimulationConfig.getSimulationData()) : (ParameterizableSimulationData)this.nodeSimulationConfig.getSimulationData();
        this.nodeSimulationConfig.setSimulationData(result);
        return result;
    }

    @Override
    public void addSimulationModifyListener(SimulationModifyListener listener) {
        super.addSimulationModifyListener(listener);
    }

    @Override
    public void modifySimulation(Object o) {
        WPVariable var = (WPVariable)o;
        this.getSimulationData().setVariable(var.getName(), var.getValue());
        this.fireSimulationModifiedEvent(this.nodeSimulationConfig);
    }
}

