/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.debugger.ui;

import com.tandbergtv.watchpoint.studio.debugger.launching.TemplateLauncherConstants;
import com.tandbergtv.watchpoint.studio.debugger.model.NodeSimulationConfig;
import com.tandbergtv.watchpoint.studio.debugger.model.ParameterizableSimulationData;
import com.tandbergtv.watchpoint.studio.debugger.model.SimulationType;
import com.tandbergtv.watchpoint.studio.debugger.ui.NodeSimulationConfigFactory;
import com.tandbergtv.watchpoint.studio.debugger.ui.SimulationModifyListener;
import com.tandbergtv.watchpoint.studio.debugger.ui.VariableNameTableLabelProvider;
import com.tandbergtv.watchpoint.studio.debugger.ui.VariableValuesTable;
import com.tandbergtv.watchpoint.studio.debugger.util.DebuggerUtils;
import com.tandbergtv.watchpoint.studio.dto.WorkflowTemplateDTO;
import com.tandbergtv.watchpoint.studio.service.IWorkflowTemplateService;
import com.tandbergtv.watchpoint.studio.service.ServiceFactory;
import com.tandbergtv.watchpoint.studio.ui.model.WPVariable;
import com.tandbergtv.watchpoint.studio.ui.model.WorkflowTemplate;
import com.tandbergtv.watchpoint.studio.ui.util.Utility;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.debug.ui.launchConfigurations.JavaLaunchTab;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.jbpm.gd.jpdl.model.NodeElement;
import org.jbpm.gd.jpdl.model.Variable;

public class TemplateLaunchMainTab
extends JavaLaunchTab {
    protected String templatePath = "";
    public static final String EMPTY_STRING = "";
    private Button fSearchButton;
    protected Text fTemplate;
    protected VariableValuesTable variableValuesTable;
    protected WorkflowTemplate template;
    protected NodeSimulationConfig nodeSimulationConfig;

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout(1, false));
        comp.setFont(parent.getFont());
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 1;
        comp.setLayoutData((Object)gd);
        ((GridLayout)comp.getLayout()).verticalSpacing = 0;
        this.createTemplateEditor(comp);
        this.createVerticalSpacer(comp, 1);
        this.createStartVariablesEditor(comp);
        this.setControl((Control)comp);
    }

    protected void createTemplateEditor(final Composite mainPanel) {
        Group group = new Group(mainPanel, 0);
        group.setLayout((Layout)new GridLayout(2, false));
        group.setText("Template");
        group.setFont(mainPanel.getFont());
        GridData gd = new GridData(768);
        gd.horizontalSpan = 1;
        group.setLayoutData((Object)gd);
        this.fTemplate = new Text((Composite)group, 2052);
        this.fTemplate.setFont(mainPanel.getFont());
        gd = new GridData(768);
        gd.horizontalSpan = 1;
        this.fTemplate.setLayoutData((Object)gd);
        this.fTemplate.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TemplateLaunchMainTab.this.setTemplate(TemplateLaunchMainTab.this.fTemplate.getText());
                ScrolledComposite sc = (ScrolledComposite)mainPanel.getParent();
                sc.setMinSize(mainPanel.computeSize(-1, -1));
                TemplateLaunchMainTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.fSearchButton = new Button((Composite)group, 8);
        this.fSearchButton.setFont(mainPanel.getFont());
        this.fSearchButton.setText("Search...");
        gd = new GridData();
        this.fSearchButton.setLayoutData((Object)gd);
        gd.horizontalAlignment = 4;
        this.fSearchButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TemplateLaunchMainTab.this.handleSearchButtonSelected();
            }
        });
    }

    protected void createStartVariablesEditor(Composite parent) {
        Group group = new Group(parent, 0);
        group.setLayout((Layout)new GridLayout(2, false));
        group.setText("Start Variables");
        group.setFont(parent.getFont());
        GridData gd = new GridData(768);
        gd.horizontalSpan = 1;
        group.setLayoutData((Object)gd);
        this.variableValuesTable = new VariableValuesTable((Composite)group);
        this.variableValuesTable.setLabelProvider(new VariableNameTableLabelProvider());
        this.variableValuesTable.addSimulationModifyListener(new SimulationModifyListener(){

            @Override
            public void modifySimulation(Object o) {
                WPVariable var = (WPVariable)o;
                TemplateLaunchMainTab.this.getSimulationData(TemplateLaunchMainTab.this.nodeSimulationConfig).setVariable(var.getName(), var.getValue());
                TemplateLaunchMainTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    public Image getImage() {
        return Utility.getImageDescriptor((String)"com.tandbergtv.watchpoint.studio.debugger", (String)"template.png").createImage();
    }

    public String getName() {
        return "Main Template";
    }

    public String getId() {
        return "com.tandbergtv.watchpoint.studio.debugger.templateMainTab";
    }

    protected void handleSearchButtonSelected() {
        WorkflowTemplateDTO templateDTO = this.chooseTemplate();
        if (templateDTO != null) {
            this.fTemplate.setText(templateDTO.getPath());
        } else {
            this.template = null;
        }
    }

    protected void setTemplate(String newTemplatePath) {
        if (newTemplatePath != null && !newTemplatePath.equals(this.templatePath)) {
            this.template = DebuggerUtils.parseWorkspaceTemplate(newTemplatePath);
            if (this.template != null) {
                List<Variable> variablesData = Collections.emptyList();
                if (this.template.getStartState().getTask() != null) {
                    variablesData = Arrays.asList(this.template.getStartState().getTask().getController().getVariables());
                }
                this.variableValuesTable.setVariablesData(variablesData);
                this.nodeSimulationConfig = new NodeSimulationConfig();
                this.nodeSimulationConfig.setNodeElement((NodeElement)this.template.getStartState());
                this.nodeSimulationConfig.setTemplateNodeName(this.template.getStartState().getName());
                this.nodeSimulationConfig.setSimulationData(new ParameterizableSimulationData());
                this.nodeSimulationConfig.setSimulationType(SimulationType.SIMULATED_VALUES);
            } else {
                this.variableValuesTable.setVariablesData(Collections.EMPTY_LIST);
                this.nodeSimulationConfig = null;
            }
            this.templatePath = newTemplatePath;
        }
    }

    public void initializeFrom(ILaunchConfiguration config) {
        super.initializeFrom(config);
        try {
            this.fTemplate.setText(config.getAttribute("com.tandberg.watchpoint.studio.template", EMPTY_STRING));
            if (this.template != null) {
                this.nodeSimulationConfig = NodeSimulationConfigFactory.createFactory().getNodeForSimulation((NodeElement)this.template.getStartState(), config.getAttributes(), null);
                this.nodeSimulationConfig.setSimulationType(SimulationType.SIMULATED_VALUES);
                ParameterizableSimulationData simulationData = this.getSimulationData(this.nodeSimulationConfig);
                for (Variable item : this.variableValuesTable.getVariablesData()) {
                    WPVariable startNodeVariable = (WPVariable)item;
                    if (!simulationData.hasVariable(startNodeVariable.getName())) continue;
                    String value = (String)simulationData.getVariable(startNodeVariable.getName());
                    startNodeVariable.setValue(value);
                }
                this.variableValuesTable.refresh();
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    public ParameterizableSimulationData getSimulationData(NodeSimulationConfig nodeSimulationConfig) {
        ParameterizableSimulationData result = null;
        result = !(nodeSimulationConfig.getSimulationData() instanceof ParameterizableSimulationData) ? new ParameterizableSimulationData(nodeSimulationConfig.getSimulationData()) : (ParameterizableSimulationData)nodeSimulationConfig.getSimulationData();
        nodeSimulationConfig.setSimulationData(result);
        return result;
    }

    public boolean isValid(ILaunchConfiguration config) {
        boolean valid;
        this.setErrorMessage(null);
        this.setMessage(null);
        boolean bl = valid = this.template != null;
        if (!valid) {
            if (!this.fTemplate.getText().isEmpty()) {
                this.setErrorMessage("Invalid Template.");
            } else {
                this.setErrorMessage("Template not specified.");
            }
        }
        return valid;
    }

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        config.setAttribute("com.tandberg.watchpoint.studio.template", this.fTemplate.getText().trim());
        if (this.template != null && this.variableValuesTable.getVariablesData() != null) {
            ParameterizableSimulationData simulationData = this.getSimulationData(this.nodeSimulationConfig);
            for (Variable item : this.variableValuesTable.getVariablesData()) {
                WPVariable startNodeVariable = (WPVariable)item;
                String value = EMPTY_STRING;
                if (startNodeVariable.getValue() != null) {
                    value = startNodeVariable.getValue();
                }
                simulationData.setVariable(startNodeVariable.getName(), value);
            }
            Map nodeAttributes = this.nodeSimulationConfig.getSimulationData().getAttributes();
            String nodeName = this.nodeSimulationConfig.getNodeElement().getName();
            if (this.nodeSimulationConfig.getSimulationType() != null) {
                config.setAttribute(TemplateLauncherConstants.getNodeSimulationTypeKey(nodeName), this.nodeSimulationConfig.getSimulationType().getValue());
            } else {
                config.removeAttribute(TemplateLauncherConstants.getNodeSimulationTypeKey(nodeName));
            }
            String dataPrefix = TemplateLauncherConstants.getNodeSimulationDataKey(nodeName);
            for (Object keyObj : nodeAttributes.keySet()) {
                String key = keyObj.toString();
                String newKey = String.valueOf(dataPrefix) + "." + key;
                config.setAttribute(newKey, (String)nodeAttributes.get(keyObj));
            }
        }
        String project = EMPTY_STRING;
        try {
            IFile templateFile = this.getWorkspaceRoot().getFile((IPath)new Path(this.fTemplate.getText()));
            if (templateFile.getProject() != null) {
                project = templateFile.getProject().getName();
                config.setMappedResources(new IResource[]{templateFile});
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, project);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        config.setAttribute("com.tandberg.watchpoint.studio.template", EMPTY_STRING);
    }

    private WorkflowTemplateDTO chooseTemplate() {
        LabelProvider labelProvider = new LabelProvider(){

            public String getText(Object element) {
                WorkflowTemplateDTO template = (WorkflowTemplateDTO)element;
                return String.valueOf(template.getName()) + " - " + template.getPath();
            }

            public Image getImage(Object element) {
                return Utility.getImageDescriptor((String)"template.png").createImage();
            }
        };
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)labelProvider);
        dialog.setTitle("Template Selection");
        dialog.setMessage("Select a Template to run.");
        IWorkflowTemplateService templateService = ServiceFactory.createFactory().createWorkflowTemplateService();
        List templates = templateService.getTemplateList();
        dialog.setElements(templates.toArray());
        String template = this.fTemplate.getText();
        if (template != null) {
            dialog.setInitialSelections(new Object[]{template});
        }
        if (dialog.open() == 0) {
            return (WorkflowTemplateDTO)dialog.getFirstResult();
        }
        return null;
    }

    protected IWorkspaceRoot getWorkspaceRoot() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    public String getTemplateLocation() {
        return this.fTemplate.getText();
    }

    public WorkflowTemplate getTemplate() {
        return this.template;
    }
}

