package com.tandbergtv.watchpoint.studio.debugger;

import org.eclipse.debug.ui.IDebugUIConstants;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.ui.IFolderLayout;
import org.eclipse.ui.IPageLayout;
import org.eclipse.ui.IPerspectiveFactory;
import org.eclipse.ui.console.IConsoleConstants;
import org.eclipse.ui.navigator.resources.ProjectExplorer;

import com.tandbergtv.watchpoint.studio.ui.util.Utility;

public class DebugPerspectiveFactory implements IPerspectiveFactory {

	public void createInitialLayout(IPageLayout layout) {
 		defineLayout(layout);
 		defineActions(layout);
	}

	public void defineLayout(IPageLayout layout) {
		String editorArea = layout.getEditorArea();

		IFolderLayout top = layout.createFolder("top", IPageLayout.TOP, 0.25f, editorArea); //$NON-NLS-1$
        top.addView(IDebugUIConstants.ID_DEBUG_VIEW);

        IFolderLayout topRight = layout.createFolder("topRight", IPageLayout.RIGHT, IPageLayout.DEFAULT_VIEW_RATIO, "top");
        topRight.addView(IDebugUIConstants.ID_BREAKPOINT_VIEW);

        IFolderLayout bottom = layout.createFolder("down", IPageLayout.BOTTOM, 0.66f, editorArea);
        bottom.addView(IConsoleConstants.ID_CONSOLE_VIEW);
	}

	public void defineActions(IPageLayout layout) {
        layout.addActionSet(JavaUI.ID_ACTION_SET);
        layout.addActionSet(JavaUI.ID_ELEMENT_CREATION_ACTION_SET);
        layout.addActionSet(IDebugUIConstants.LAUNCH_ACTION_SET);

        layout.addShowViewShortcut(Utility.ID_OVERVIEW);
        layout.addShowViewShortcut(ProjectExplorer.VIEW_ID);
        layout.addShowViewShortcut(IPageLayout.ID_PROBLEM_VIEW);
        layout.addShowViewShortcut(IPageLayout.ID_PROP_SHEET);
        layout.addShowViewShortcut(Utility.ID_RESOURCE_TYPE);
        layout.addShowViewShortcut(Utility.ID_RESOURCE_GROUP);

        layout.addNewWizardShortcut("com.tandbergtv.watchpoint.studio.wizard.new.template"); //$NON-NLS-1$
        layout.addNewWizardShortcut("com.tandbergtv.watchpoint.studio.wizard.new.resourcegroup"); //$NON-NLS-1$
        layout.addNewWizardShortcut("com.tandbergtv.watchpoint.studio.wizard.new.resourcetype");
        layout.addNewWizardShortcut("org.jbpm.gd.jpdl.wizard.new.project");
	}
}