/*
 * $HeadURL: $
 * $Id: $
 * Copyright (c) 2013 by Ericsson, all rights reserved.
 */
 
package com.tandbergtv.watchpoint.studio.ui.propertytester;

import org.eclipse.core.expressions.PropertyTester;
import org.jbpm.gd.common.model.SemanticElement;
import org.jbpm.gd.jpdl.model.SuperState;

import com.tandbergtv.watchpoint.studio.ui.editor.WPNodeGraphicalEditPart;
import com.tandbergtv.watchpoint.studio.ui.model.NodeDefinition;
 
/**
 *
 * @author ehuahao
 */
public class BreakpointPropertyTester extends PropertyTester {

    @Override
    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        // The property under inspection is not a AbstractEditPart
        if (!WPNodeGraphicalEditPart.class.isAssignableFrom(receiver.getClass())) {
            return false;
        }

        SemanticElement se = ((WPNodeGraphicalEditPart) receiver).getNotationElement().getSemanticElement();

        return se instanceof SuperState || se instanceof NodeDefinition;
    }
}
