/*
 * Created on Jun 18, 2007
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.watchpoint.studio.dto;

import java.io.Serializable;

/**
 * Interface indicating that the implementing class can be persisted.
 * 
 * @author Vijay Silva
 */
public interface IPersistable extends IWatchPointDTO, Cloneable
{
	/**
	 * The Default ID used by all entities that need to be initially created in the DB.
	 */
	public static final long DEFAULT_ID = -1;

	/**
	 * Get the Key for this persistable object
	 * 
	 * @return The Serializable Key for the this persistable object
	 */
	Serializable getKey();

	/**
	 * Creates a clone of the Persistable object
	 * 
	 * @return A Clone of this Entity object
	 * 
	 * @throws CloneNotSupportedException
	 *             Thrown if the object does not support cloning
	 * 
	 * @see java.lang.Object#clone()
	 */
	public IPersistable clone() throws CloneNotSupportedException;
}
