/*
 * Created on June 5, 2007
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.watchpoint.studio.dto;

import java.util.HashSet;
import java.util.Set;

/**
 * The Node Definition DTO.
 * 
 * @author Imran Naqvi
 * 
 */
public class NodeDefinitionDTO implements IWatchPointDTO, IPersistable
{
	private static final long serialVersionUID = -379014790956472071L;

	private long id = DEFAULT_ID;

	private String name;

	private NodeDefinitionType type;

	private String xml;

	private String gpd;
	
	private String path;

	private ResourceType resourceType;

	private Set<Message> messages;

	private Set<NodeDefinitionDTO> children;

	/**
	 * Default Constructor
	 */
	public NodeDefinitionDTO()
	{
		super();
		this.messages = new HashSet<Message>();
		this.children = new HashSet<NodeDefinitionDTO>();
	}

	public void setPath(String path) {
		this.path = path;
	}

	public String getPath() {
		return path;
	}

	/**
	 * Get the Node Definition Id
	 * 
	 * @see com.tandbergtv.watchpoint.studio.dto.IPersistable#getKey()
	 */
	public Long getKey()
	{
		return this.id;
	}

	/**
	 * 
	 * @return the Id
	 */
	public long getId()
	{
		return id;
	}

	/**
	 * 
	 * @param id
	 *            The Id
	 */
	public void setId(long id)
	{
		this.id = id;
	}

	/**
	 * 
	 * @return the name of this node definition
	 */
	public String getName()
	{
		return name;
	}

	/**
	 * 
	 * @param name
	 *            the name to set
	 */
	public void setName(String name)
	{
		this.name = name;
	}

	/**
	 * 
	 * @return the resource type of this node definition
	 */
	public ResourceType getResourceType()
	{
		return resourceType;
	}

	/**
	 * 
	 * @param resourceType
	 *            the resource type to set
	 */
	public void setResourceType(ResourceType resourceType)
	{
		this.resourceType = resourceType;
	}

	/**
	 * 
	 * @return the type of this node definition
	 */
	public NodeDefinitionType getType()
	{
		return type;
	}

	/**
	 * 
	 * @param type
	 *            the type to set
	 */
	public void setType(NodeDefinitionType type)
	{
		this.type = type;
	}

	/**
	 * 
	 * @return the xml representing this node definition
	 */
	public String getXml()
	{
		return xml;
	}

	/**
	 * 
	 * @param xml
	 *            The xml to set
	 */
	public void setXml(String xml)
	{
		this.xml = xml;
	}

	/**
	 * 
	 * @return the set of messages that nodes within this node definition use
	 */
	public Set<Message> getMessages()
	{
		return messages;
	}

	/**
	 * 
	 * @param messages
	 *            the set of messages to set
	 */
	public void setMessages(Set<Message> messages)
	{
		this.messages = messages;
	}
	
	/**
	 * @param message
	 */
	public void addMessage(Message message)
	{
		this.messages.add(message);
	}
	
	/**
	 * @param message
	 */
	public void removeMessage(Message message)
	{
		this.messages.remove(message);
	}

	/**
	 * @return The set of Node Definitions used
	 */
	public Set<NodeDefinitionDTO> getChildren()
	{
		return children;
	}

	/**
	 * @param children
	 *            The set of Node Definitions used
	 */
	public void setChildren(Set<NodeDefinitionDTO> children)
	{
		this.children = children;
	}
	
	public void addChild(NodeDefinitionDTO child)
	{
		this.children.add(child);
	}

	/**
	 * 
	 * @return The GPD document contents
	 */
	public String getGpd()
	{
		return gpd;
	}

	/**
	 * 
	 * @param gpd
	 *            The GPD document contents
	 */
	public void setGpd(String gpd)
	{
		this.gpd = gpd;
	}

	/**
	 * @see java.lang.Object#hashCode()
	 */
	@Override
	public int hashCode()
	{
		if (this.id == DEFAULT_ID)
			return super.hashCode();

		return new Long(this.id).hashCode() * 7 - 127;
	}

	/**
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	@Override
	public boolean equals(Object obj)
	{
		if (!(obj instanceof NodeDefinitionDTO))
			return false;

		NodeDefinitionDTO key = (NodeDefinitionDTO) obj;

		/* Check for the Default Id */
		if (this.id == DEFAULT_ID && key.id == DEFAULT_ID)
			return super.equals(key);

		return (this.id == key.id);
	}

	/**
	 * Creates a clone of the Node Definition.
	 * 
	 * @see java.lang.Object#clone()
	 */
	@Override
	public NodeDefinitionDTO clone()
	{
		NodeDefinitionDTO clone = null;

		try
		{
			clone = (NodeDefinitionDTO) super.clone();

			// Shallow clone of the messages
			if (this.messages != null)
			{
				clone.messages = new HashSet<Message>(this.messages);
			}

			// Shallow clone of the child Node Definitions
			if (this.children != null)
			{
				clone.children = new HashSet<NodeDefinitionDTO>(this.children);
			}
		}
		catch (CloneNotSupportedException ex)
		{ // Should never happen
		}

		return clone;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String toString()
	{
		return "Node " + getName();
	}
}
