/**
 * DataAccessFactoryImpl.java
 * Created Feb 12, 2010
 */
package com.tandbergtv.watchpoint.studio.external.fs.dao;

import java.io.Serializable;

import com.tandbergtv.watchpoint.studio.application.StudioRuntimeException;
import com.tandbergtv.watchpoint.studio.dataaccess.DataAccessFactory;
import com.tandbergtv.watchpoint.studio.dataaccess.DataAccessInterface;
import com.tandbergtv.watchpoint.studio.dataaccess.IPersistenceContext;
import com.tandbergtv.watchpoint.studio.dataaccess.MessageDAI;
import com.tandbergtv.watchpoint.studio.dataaccess.NodeDefinitionDTODAI;
import com.tandbergtv.watchpoint.studio.dataaccess.ProtectionKeyDAI;
import com.tandbergtv.watchpoint.studio.dataaccess.ResourceGroupDAI;
import com.tandbergtv.watchpoint.studio.dataaccess.ResourceTypeDAI;
import com.tandbergtv.watchpoint.studio.dataaccess.WorkflowTemplateDTODAI;
import com.tandbergtv.watchpoint.studio.dto.IPersistable;
import com.tandbergtv.watchpoint.studio.external.fs.FileSystemContext;
import com.tandbergtv.watchpoint.studio.external.jpf.JPFContext;

/**
 * Factory for the JPF data access layer
 * 
 * @author Sahil Verma
 */
public class DataAccessFactoryImpl extends DataAccessFactory {

	/**
	 * Default ctor
	 */
	public DataAccessFactoryImpl() {
	}

	/**
	 * {@inheritDoc}
	 */
	@SuppressWarnings("unchecked")
	@Override
	public <DO extends IPersistable, DOK extends Serializable> DataAccessInterface<DO, DOK> createDataAccessObject(
			DO entity, IPersistenceContext context) {
		Class<? extends IPersistable> entityClass = entity.getClass();
		return (DataAccessInterface<DO, DOK>) this.createDataAccessObject(entityClass, context);
	}

	/**
	 * {@inheritDoc}
	 */
	@SuppressWarnings("unchecked")
	@Override
	public <DO extends IPersistable, DOK extends Serializable> DataAccessInterface<DO, DOK> createDataAccessObject(
			Class<DO> entityClass, IPersistenceContext context) {

		String entityClassName = entityClass.getName();
		String daoClassName = null;

		try
		{
			String simpleEntityClassName = entityClass.getSimpleName();
			String daoPackageName = this.getClass().getPackage().getName();
			daoClassName = daoPackageName + "." + simpleEntityClassName + "DAO";
			Class<?> clazz = Class.forName(daoClassName);
			Object instance = clazz.getConstructor(context.getClass()).newInstance(context);

			return (DataAccessInterface<DO, DOK>) instance;
		}
		catch (Exception ex)
		{
			String errMsg = "Failed to instantiate JPA Data Access Object: " + daoClassName
					+ " for entity class: " + entityClassName;
			throw new StudioRuntimeException(errMsg, ex);
		}
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public ResourceTypeDAI getResourceTypeDAO(IPersistenceContext context) {
		return new ResourceTypeDAO((JPFContext) context);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public WorkflowTemplateDTODAI getWorkflowTemplateDTODAO(IPersistenceContext context) {
		return new TemplateDAO(FileSystemContext.class.cast(context));
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public ResourceGroupDAI getResourceGroupDAO(IPersistenceContext context) {
		return new ResourceGroupDAO((JPFContext) context);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public NodeDefinitionDTODAI getNodeDefinitionDTODAO(IPersistenceContext context) {
		throw new UnsupportedOperationException();
	}
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	public MessageDAI getMessageDAO(IPersistenceContext context) {
		throw new UnsupportedOperationException();
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public ProtectionKeyDAI getProtectionKeyDAO(IPersistenceContext context) {
		throw new UnsupportedOperationException();
	}
}
