package com.tandbergtv.watchpoint.studio.external.fs.dao;

import java.io.IOException;
import java.util.List;

import javax.xml.transform.TransformerException;
import javax.xml.xpath.XPathException;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;

import com.tandbergtv.watchpoint.studio.dto.ResourceGroup;
import com.tandbergtv.watchpoint.studio.external.jpf.JPFContextFactory;
import com.tandbergtv.watchpoint.studio.service.IResourceGroupService;
import com.tandbergtv.watchpoint.studio.service.ServiceFactory;
import com.tandbergtv.watchpoint.studio.service.impl.ServiceImpl;

public class ResourceGroupParser {

	/**
	 * Parses a ResourceGroup
	 * 
	 * @param file
	 * @return
	 * @throws TransformerException 
	 * @throws XPathException 
	 * @throws CoreException 
	 * @throws IOException 
	 */
	public static ResourceGroup parse(IFile file) {
		IResourceGroupService service = ServiceFactory.createFactory().createResourceGroupService();
		
		((ServiceImpl) service).setDataAccessFactory(new DataAccessFactoryImpl());
		((ServiceImpl) service).setPersistenceContextFactory(new JPFContextFactory(file.getParent().getLocation().toPortableString()));

		List<ResourceGroup> groups = IResourceGroupService.class.cast(service).getAllResourceGroups();
		ResourceGroup group = null; 
		if (!groups.isEmpty()) {
			group = groups.get(0);
		}
		return group;
	}

}
