/*
 * Created on Aug 2, 2007
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.watchpoint.studio.external.wpexport;

/**
 * Exception that occurs when the Export Process fails.
 * 
 * @author Vijay Silva
 */
public class ExportFailureException extends Exception
{
	private static final long serialVersionUID = -7636098386717940854L;

	/**
	 * Constructor
	 */
	public ExportFailureException()
	{
		super();
	}

	/**
	 * Constructor
	 * 
	 * @param message
	 *            The detail message
	 * @param cause
	 *            The nested throwable
	 */
	public ExportFailureException(String message, Throwable cause)
	{
		super(message, cause);
	}

	/**
	 * Constructor
	 * 
	 * @param message
	 *            The detail message
	 */
	public ExportFailureException(String message)
	{
		super(message);
	}

	/**
	 * Constructor
	 * 
	 * @param cause
	 *            The nested throwable
	 */
	public ExportFailureException(Throwable cause)
	{
		super(cause);
	}
}
