/*
 * Created on Jun 26, 2007
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.watchpoint.studio.service;

import com.tandbergtv.watchpoint.studio.service.impl.MessageUIDGenerator;
import com.tandbergtv.watchpoint.studio.service.impl.NodeDefinitionService;
import com.tandbergtv.watchpoint.studio.service.impl.ResourceGroupService;
import com.tandbergtv.watchpoint.studio.service.impl.ResourceTypeService;
import com.tandbergtv.watchpoint.studio.service.impl.WorkflowTemplateService;
import com.tandbergtv.watchpoint.studio.util.ClassLoaderUtil;

/**
 * Abstract Factory for instantiating Data Access objects.
 * 
 * @author Vijay Silva
 */
public class ServiceFactory
{
	private static final String DEFAULT_FACTORY = "com.tandbergtv.watchpoint.studio.service.ServiceFactory";

	/**
	 * Constructor
	 */
	public ServiceFactory()
	{
		super();
	}

	// ========================================================================
	// ==================== FACTORY CREATION
	// ========================================================================

	/**
	 * Return the configured Data Access Factory to use for creating Data Access Objects.
	 * 
	 * @return The DataAccessFactory
	 */
	public static ServiceFactory createFactory()
	{
		return ClassLoaderUtil.createFactoryInstance(DEFAULT_FACTORY, ServiceFactory.class);
	}

	// ========================================================================
	// ==================== GENERIC OBJECT CREATION
	// ========================================================================

	/**
	 * Create an instance of the IWorkflowTemplateService service.
	 * 
	 * @return The Service implementation
	 */
	public IWorkflowTemplateService createWorkflowTemplateService()
	{
		return new WorkflowTemplateService();
	}

	/**
	 * Create an instance of the INodeDefinitionService service.
	 * 
	 * @return The Service implementation
	 */
	public INodeDefinitionService createNodeDefinitionService()
	{
		return new NodeDefinitionService();
	}

	/**
	 * Create an instance of the IResourceGroupService service.
	 * 
	 * @return The Service implementation
	 */
	public IResourceGroupService createResourceGroupService()
	{
		return new ResourceGroupService();
	}

	/**
	 * Create an instance of the IResourceTypeService service.
	 * 
	 * @return The Service implementation
	 */
	public IResourceTypeService createResourceTypeService()
	{
		return new ResourceTypeService();
	}

	/**
	 * Create an instance of the IMessageUIDGenerator.
	 * 
	 * @return The Message UID Generator
	 */
	public IMessageUIDGenerator createMessageUIDGenerator()
	{
		return new MessageUIDGenerator();
	}
}
