/**
 * AbstractCommand.java
 * Created Apr 14, 2010
 */
package com.tandbergtv.watchpoint.studio.ui.command;

/**
 * Provides bare bones implementation of an {@link ICommand}
 * 
 * @author Sahil Verma
 */
public abstract class AbstractCommand implements ICommand {
	
	private String name;
	
	private boolean enabled;
	
	private String description;
	
	/**
	 * @param name
	 * @param description
	 */
	protected AbstractCommand(String name, String description) {
		this(name, description, true);
	}
	
	/**
	 * @param name
	 * @param description
	 */
	protected AbstractCommand() {
	}

	/**
	 * @param name
	 * @param description
	 * @param enabled
	 */
	protected AbstractCommand(String name, String description, boolean enabled) {
		super();
		this.name = name;
		this.description = description;
		this.enabled = enabled;
	}

	/**
	 * {@inheritDoc}
	 */
	public String getDescription() {
		return description;
	}

	/**
	 * {@inheritDoc}
	 */
	public String getName() {
		return name;
	}

	/**
	 * {@inheritDoc}
	 */
	public boolean isEnabled() {
		return enabled;
	}
}
