package com.tandbergtv.watchpoint.studio.ui.editor;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.handlers.HandlerUtil;
import org.jbpm.gd.common.part.NodeContainerGraphicalEditPart;
import org.jbpm.gd.common.part.RootContainerGraphicalEditPart;
import org.jbpm.gd.jpdl.model.StartState;
import org.jbpm.gd.jpdl.notation.JpdlNode;

public class TemplateEditorCopyCommandHandler extends AbstractHandler {

	@Override
	public void dispose() {
        //
	}

	@Override
	public Object execute(ExecutionEvent event) throws ExecutionException {
		// Get selection
		IStructuredSelection editorSelection = getEditorSelection(event);
		if(editorSelection != null){
			// Create command class
			if( isEnabled() ){
				TemplateEditorCopyCommand command = new TemplateEditorCopyCommand( getElementsList(editorSelection) );
				command.execute();
			}
		} else {
			System.out.println("Selection not processed.");
		}
		
		return null;
	}
	
	private IStructuredSelection getEditorSelection(ExecutionEvent event){
		ISelection selection = HandlerUtil.getCurrentSelection(event);
		if(selection instanceof StructuredSelection){
			return (IStructuredSelection) selection;
		} else {
			return null;
		}
	}
	
    protected List<Object> getElementsList(IStructuredSelection editorSelection) {
        List<Object> copy = new ArrayList<Object>();
        for (Object graphicalNode : editorSelection.toList()) {
            if (canCopy(graphicalNode)) {
                copy.add(graphicalNode);
            }
        }

        List<Object> clone = new ArrayList<Object>(copy);

        // remove duplicate nodes that is already inside the loop node
        removeDuplicateNode(clone, copy);

        return copy;
    }

    /**
     * Remove the node which is the children of a container node(Loop node) that is also recognized as a copied object.
     * 
     * @param sample
     *            the cloned list used as a scanning sample
     * @param target
     *            the target list that is to be modified
     */
    private void removeDuplicateNode(List<Object> sample, List<Object> target) {
        for (Object node : sample) {
            if (node instanceof NodeContainerGraphicalEditPart) {
                target.removeAll(((NodeContainerGraphicalEditPart) node).getChildren());
                @SuppressWarnings("unchecked")
                List<Object> clone = new ArrayList<Object>(((NodeContainerGraphicalEditPart) node).getChildren());
                removeDuplicateNode(clone, target);
            }
        }
    }
	
    protected boolean canCopy(Object object) {
		boolean canCopy = true;
		
		// check if its a template
		if (object instanceof RootContainerGraphicalEditPart) {
            return false;
        }
		// it its a simple node check if its the start state node
		if (object instanceof WPNodeGraphicalEditPart){
			WPNodeGraphicalEditPart graphicalNode = (WPNodeGraphicalEditPart) object;
			JpdlNode jpdlNode = (JpdlNode) graphicalNode.getModel();
			if ( jpdlNode.getSemanticElement() instanceof StartState){
				canCopy = false;
			}
		}
		
		return canCopy;
	}

	@Override
	public void setEnabled(Object evaluationContext) {
		super.setBaseEnabled(true);
	}
}