package com.tandbergtv.watchpoint.studio.ui.editor;

import org.jbpm.gd.jpdl.command.EdgeCreateCommand;
import org.jbpm.gd.jpdl.model.Decision;
import org.jbpm.gd.jpdl.model.Fork;
import org.jbpm.gd.jpdl.model.NodeElement;
import org.jbpm.gd.jpdl.model.Transition;
import org.jbpm.gd.jpdl.notation.JpdlNodeContainer;

/**
 * @author rprakash
 *
 * Custom Edge Create Command that gets executed when a new Transition is
 * created in the UI.
 */
public class WPEdgeCreateCommand extends EdgeCreateCommand {
	
	/**
	 * @see org.jbpm.gd.jpdl.command.EdgeCreateCommand#execute()
	 */
	@Override
	public void execute() {
		super.execute();
		setTransitionAttributes();
	}
	
	@Override
	public boolean canExecute() {
		boolean canExecute = true;
		canExecute = super.canExecute();
		if(target != null && source != null){
			/* Unable the command if the source and target are in different sides of a loop node */
			if ( source.getContainer() instanceof JpdlNodeContainer && !(target.getContainer() instanceof JpdlNodeContainer) ||
				 target.getContainer() instanceof JpdlNodeContainer && !(source.getContainer() instanceof JpdlNodeContainer) ){
				canExecute = false;
			}
		}
		return canExecute;
	}

	private void setTransitionAttributes() {
		NodeElement transitionSource = (NodeElement) source.getSemanticElement();
		Transition transition = (Transition) edge.getSemanticElement();
		if (transitionSource instanceof Decision || transitionSource instanceof Fork) {
			if(isNullOrBlank(transition.getName())) {
				transition.setName("to " + transition.getTo());
				edge.getLabel().setText(transition.getName());
			}
		}
	}

	private boolean isNullOrBlank(String str) {
		return (str == null || str.trim().length() == 0);
	}
}
