package com.tandbergtv.watchpoint.studio.ui.editor;

import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Label;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Color;
import org.jbpm.gd.common.figure.NodeHeaderFigure;
import org.jbpm.gd.jpdl.Constants;

/**
 * This class is a replacement to NodeHeaderFigure so the breakpoint icons are shown.
 * 
 * @autor beroubach
 */
public class WPHeaderFigure extends NodeHeaderFigure {

    private Figure embeddedFigure;
    private Color foregroundColor = Constants.veryLightGray;
    private static final Color HIGHLIGHT_COLOR = new Color(null, 22, 130, 124);
    
	public Figure getEmbeddedFigure() {
		return embeddedFigure;
	}

	public void setEmbeddedFigure(Figure embeddedFigure) {
		this.embeddedFigure = embeddedFigure;
	}

	public WPHeaderFigure(String nodeType, boolean hideName, ImageDescriptor imageDescriptor,
			ImageDescriptor transparentImageDescriptor) {
		super(nodeType, hideName, imageDescriptor, transparentImageDescriptor);
	}

	public void addBreakpoint(ImageDescriptor breakpointImageDescriptor) {
		Label label = (Label) getEmbeddedFigure().getChildren().get(1);
		label.setIcon(getNodeIcon(breakpointImageDescriptor));
	}

	public void removeBreakpoint(ImageDescriptor transparentImageDescriptor) {
		Label label = (Label) getEmbeddedFigure().getChildren().get(1);
		label.setIcon(getNodeIcon(transparentImageDescriptor));
	}
	
	protected  Color getClientAreaColor(){
		return foregroundColor;
	}

	public void removeBackgroundHighlight() {
		foregroundColor = Constants.veryLightGray;
	}

	public void addBackgroundHighlight() {
		foregroundColor = HIGHLIGHT_COLOR;
	}
}