/**
 * 
 */
package com.tandbergtv.watchpoint.studio.ui.editor;

import java.beans.PropertyChangeEvent;

import org.jbpm.gd.common.notation.Node;
import org.jbpm.gd.jpdl.model.NodeElement;
import org.jbpm.gd.jpdl.model.NodeElementContainer;
import org.jbpm.gd.jpdl.notation.JpdlEdge;

/**
 * An extension of JBPM's JpdlEdge class modified to handle edges in both templates and node definitions.
 * 
 * @author Imran Naqvi
 *
 */
public class WPJpdlEdge extends JpdlEdge {

	/**
	 * @see org.jbpm.gd.jpdl.notation.JpdlEdge#propertyChange(java.beans.PropertyChangeEvent)
	 */
	@Override
	public void propertyChange(PropertyChangeEvent evt) {
		String eventName = evt.getPropertyName();
		if (eventName.equals("to")) {
			if (getSource() == null) return;
			NodeElementContainer container = (NodeElementContainer)((Node)getSource()).getContainer().getSemanticElement();
			NodeElement newTarget = container.getNodeElementByName((String)evt.getNewValue());
			NodeElement oldTarget = container.getNodeElementByName((String)evt.getOldValue());
			if (oldTarget != null) {
				Node oldTargetNode = (Node)getRegisteredNotationElementFor(oldTarget);
				if (oldTargetNode != null) {
					oldTargetNode.removeArrivingEdge(this);
				}
			}
			if (newTarget != null) {
				Node targetNode = (Node)getRegisteredNotationElementFor(newTarget);
				if (targetNode != null) {
					targetNode.addArrivingEdge(this);
				}
			}
		} else {
			super.propertyChange(evt);
		}
	}
}
