package com.tandbergtv.watchpoint.studio.ui.editor;

import java.beans.PropertyChangeEvent;

import org.jbpm.gd.common.model.SemanticElement;
import org.jbpm.gd.common.notation.Node;
import org.jbpm.gd.jpdl.notation.JpdlNodeContainer;

import com.tandbergtv.watchpoint.studio.ui.model.LoopNode;
import com.tandbergtv.watchpoint.studio.util.WPNodeContainerHandler;

/**
 * Class that represents the LoopNode notation element. <br>
 * We need to extend the JpdlNodeContainer because that class doesn't update the transitions
 * after rename the loop node element.
 * @author Patrik Araujo
 *
 */
public class WPNodeContainer extends JpdlNodeContainer {

	@Override
	public void propertyChange(PropertyChangeEvent evt) {
		super.propertyChange(evt);

		WPNodeContainerHandler.handlePropertyChange(this, evt);
	}

	@Override
	public void setSemanticElement(SemanticElement semanticElement) {
		super.setSemanticElement(semanticElement);
		LoopNode loopNode = (LoopNode)semanticElement;
		int index = 0;
		for (Object childNode : getNodes()) {
			Node node = (Node)childNode;
			node.setSemanticElement( loopNode.getNodeElements()[index] );
			index++;
		};
	}
	
}
