package com.tandbergtv.watchpoint.studio.ui.editor.resourcetype.formpart.fields;

import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;

import com.tandbergtv.watchpoint.studio.dto.ResourceType;

/**
 * Interface used by classes implementing a resource type field defined by an extension point
 * to be shown on the general page of a resource type editor.
 * @author Patrik Araujo
 *
 */
public interface IResourceTypeGeneralPageInputField {
	/**
	 * Create the controls .
	 * @param parent The given composite area to be used to create the controls.
	 * @param labelData The label layout data.
	 * @param controlData The control layout data.
	 */
	public void createControls(Composite parent, GridData labelData, GridData controlData);
	
	/**
	 * Initialize the control values.<br>
	 * Each class is responsible for initialize the control values. Combobox is an example of
	 * a control that need to be initialized with the options values.  
	 */
	public void initValues();
	
	/**
	 * Sets the existing value for a control.
	 * @param resourceType The resource type that gives the value to be set to the control.
	 */
	public void setCurrentValue(ResourceType resourceType);
	
	/**
	 * Sets the value from the control to the resource type.
	 * @param resourceType The resource type to have the value set.
	 */
	public void setObjectValues(ResourceType resourceType);
	
	/**
	 * Clears the control values.
	 */
	public void clearControls();
	
	/**
	 * Set the permissions of the section widgets based on the input.
	 * @param isEditable Boolean flag to indicate if the editor input can be edited.
	 */
	public void setWidgetPermission(boolean isEditable);
	
	/**
	 * Validates the field input.
	 * @return String containing the error message in case of error.
	 */
	public String validate();
	
	/**
	 * Sets a modify listener for the control, then the page can be notified if it should be
	 * marked like dirty.
	 * @param validationListener The listener to be set to the control.
	 */
	public void setFormPartDirtyModifyListener(ModifyListener validationListener);
	
}
