package com.tandbergtv.watchpoint.studio.ui.properties;

import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.TableColumn;

import com.tandbergtv.watchpoint.studio.ui.model.WPVariable;

public class ManualTaskNodeLabelProvider extends WPLabelProvider {

    public ManualTaskNodeLabelProvider(TableColumn requiredColumn, TableColumn readColumn, TableColumn writeColumn) {
        this.columns = new TableColumn[] { requiredColumn, null, readColumn, writeColumn };
    }

    @Override
    public Image getColumnImage(Object element, int columnIndex) {
        WPVariable model = (WPVariable) element;
        switch (columnIndex) {
        case 2:
            return getCheckImage(model.isRequired());
        case 4:
            return getCheckImage(model.isReadable());
        case 5:
            return getCheckImage(model.isWritable());
        }
        return null;
    }

    @Override
    public String getColumnText(Object element, int columnIndex) {
        switch (columnIndex) {
        case 0:
            return ((WPVariable) element).getMappedName();
        case 1:
            return ((WPVariable) element).getName();
        case 3:
            return ((WPVariable) element).getEmptySafeType();
        case 6:
            return ((WPVariable) element).getValue();
        }
        return null;
    }
}