package com.tandbergtv.watchpoint.studio.ui.properties;

import java.util.List;

import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.TableItem;

import com.tandbergtv.watchpoint.studio.ui.model.WPVariable;

public class ProcessStateCellModifier implements ICellModifier {

    private String[] columnNames;
    private TableViewer tableViewer;
    private List<String> variableNames;

    public ProcessStateCellModifier(TableViewer tableViewer, String[] columnNames) {
        this.tableViewer = tableViewer;
        this.columnNames = columnNames;
    }

    @Override
    public boolean canModify(Object element, String property) {
        return true;
    }

    @Override
    public Object getValue(Object element, String property) {
        WPVariable variable = (WPVariable) element;

        if (property.equals(columnNames[0])) {
            return variable.getName();
        } else if (property.equals(columnNames[1])) {
            if (variableNames != null) {
                String stringValue = variable.getMappedName();
                int i = variableNames.size() - 1;
                while (i > 0 && !stringValue.equals(variableNames.get(i))) {
                    --i;
                }
                return new Integer(i);
            } else {
                return variable.getMappedName();
            }

        } else if (property.equals(columnNames[2])) {
            return variable.isReadable();
            
        } else if (property.equals(columnNames[3])) {
            return variable.isWritable();
        }

        return variable.isRequired();
    }

    @Override
    public void modify(Object element, String property, Object value) {
        WPVariable variable = (WPVariable) ((TableItem) element).getData();

        if (property.equals(columnNames[0])) {
            variable.setName((String) value);

        } else if (property.equals(columnNames[1])) {
            if (variableNames != null) {
                if ((Integer) value > -1) {
                    if (variableNames == null) {
                        return;
                    }

                    Integer index = (Integer) value;
                    variable.setMappedName(variableNames.get(index));
                }
            } else {
                variable.setMappedName((String) value);
            }

        } else if (property.equals(columnNames[2])){
            variable.setReadable((Boolean) value);

        } else if (property.equals(columnNames[3])){
            variable.setWritable((Boolean) value);
            variable.markError((Boolean) value);

        } else if (property.equals(columnNames[4])){
            variable.setRequired((Boolean) value);
        }

        tableViewer.update(variable, columnNames);
    }

    public void setVariables(List<String> variables) {
        this.variableNames = variables;
    }
}