package com.tandbergtv.watchpoint.studio.ui.properties;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

import com.tandbergtv.watchpoint.studio.ui.model.NodeDefinition;

public class ResourceReuseSectionComposite implements SelectionListener {

    private TabbedPropertySheetWidgetFactory widgetFactory;
    private Composite parent;
    private Button reuseCheckbox;
    private NodeDefinition nodeDefinition;

    public ResourceReuseSectionComposite(TabbedPropertySheetWidgetFactory widgetFactory, Composite parent) {
        this.widgetFactory = widgetFactory;
        this.parent = parent;
        create();
    }

    private void create() {
        reuseCheckbox = widgetFactory.createButton(parent, PropertiesMessages.ResourceReuseSectionComposite_reuseCheckbox_label, SWT.CHECK);
        reuseCheckbox.setLayoutData(createReuseCheckboxLayoutData());
        reuseCheckbox.pack();
    }

    private FormData createReuseCheckboxLayoutData() {
        FormData data = new FormData();
        data.left = new FormAttachment(0, 105);
        data.top = new FormAttachment(0, 0);
        data.width = 400;
        return data;
    }

    public void refresh() {
        reuseCheckbox.removeSelectionListener(this);
        reuseCheckbox.setSelection(nodeDefinition.hasSetResourceAction());
        reuseCheckbox.addSelectionListener(this);
    }

    public void setNodeDefinition(NodeDefinition nodeDefinition) {
        this.nodeDefinition = nodeDefinition;
    }

    @Override
    public void widgetSelected(SelectionEvent e) {
        nodeDefinition.toggleSetResourceAction();
    }

    @Override
    public void widgetDefaultSelected(SelectionEvent e) {
        nodeDefinition.toggleSetResourceAction();
   }
}