/**
 * 
 */
package com.tandbergtv.watchpoint.studio.ui.properties;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.jbpm.gd.common.notation.AbstractNotationElement;
import org.jbpm.gd.common.part.NotationElementGraphicalEditPart;
import org.jbpm.gd.common.part.OutlineEditPart;

import com.tandbergtv.watchpoint.studio.ui.model.NodeDefinition;

/**
 * Property section for viewing the resource type of an element.
 * 
 * @author Imran Naqvi
 *
 */
public class ResourceTypeElementSection extends AbstractPropertySection {
	
	private ResourceTypeElementConfigurationComposite resourceTypeElementConfigurationComposite;
	
	private NodeDefinition resourceTypeElement;
	
	/**
	 * @see org.eclipse.ui.views.properties.tabbed.AbstractPropertySection#createControls(org.eclipse.swt.widgets.Composite, org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage)
	 */
	public void createControls(Composite parent,
            TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        Composite clientArea = getWidgetFactory().createFlatFormComposite(parent);
        resourceTypeElementConfigurationComposite = ResourceTypeElementConfigurationComposite.create(getWidgetFactory(), clientArea);
    }
 
 	/**
 	 * @see org.eclipse.ui.views.properties.tabbed.AbstractPropertySection#setInput(org.eclipse.ui.IWorkbenchPart, org.eclipse.jface.viewers.ISelection)
 	 */
 	public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        if (!(selection instanceof IStructuredSelection)) return;
        Object input = ((IStructuredSelection)selection).getFirstElement();
        if (input instanceof NotationElementGraphicalEditPart) {
        	AbstractNotationElement notationElement = ((NotationElementGraphicalEditPart)input).getNotationElement();
        	NodeDefinition nodeSelected = (NodeDefinition)notationElement.getSemanticElement();
        	setResourceGroupElement(nodeSelected);
        } else if (input instanceof OutlineEditPart) {
        	NodeDefinition nodeSelected = (NodeDefinition)((OutlineEditPart)input).getModel();
        	setResourceGroupElement(nodeSelected);
        }
    }
 	
 	/**
 	 * @see org.eclipse.ui.views.properties.tabbed.AbstractPropertySection#refresh()
 	 */
 	public void refresh() {
 		if (resourceTypeElement != null) {
 			resourceTypeElementConfigurationComposite.setResourceTypeElement(resourceTypeElement);
 		}
    }
 	
 	/**
 	 * Sets the resource group element.
 	 * 
 	 * @param resourceTypeElement
 	 */
 	private void setResourceGroupElement(NodeDefinition resourceTypeElement) {
 		this.resourceTypeElement = resourceTypeElement;
 	}

}
