package com.tandbergtv.watchpoint.studio.ui.properties;

import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TableColumn;

import com.tandbergtv.watchpoint.studio.ui.model.WPVariable;

public class SuperStateVariablesLabelProvider extends WPLabelProvider {

    public SuperStateVariablesLabelProvider(TableColumn attachmentColumn, TableColumn compositeKeyColumn) {
        this.columns = new TableColumn[] { attachmentColumn, null, compositeKeyColumn };
    }
    
    @Override
    public Image getColumnImage(Object element, int columnIndex) {
        WPVariable model = (WPVariable) element;
        switch (columnIndex) {
        case 1:
            return getCheckImage(model.isAttachment());
        case 3:
            return getCheckImage(model.isCompositeKey());
        }
        return null;
    }

    @Override
    public String getColumnText(Object element, int columnIndex) {
        WPVariable model = (WPVariable) element;
        switch (columnIndex) {
        case 0:
            return model.getMappedName();
        case 2:
            return model.getEmptySafeType();
        }
        return null;
    }

    @Override
    protected int getColumnIndex(Event event) {
        return event.index - 1;
    }
}