/*
 * Created on Aug 6, 2007
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.watchpoint.studio.ui.properties;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.jbpm.gd.common.model.SemanticElement;

import com.tandbergtv.watchpoint.studio.ui.model.AutomaticTaskNode;
import com.tandbergtv.watchpoint.studio.ui.util.Utility;

/**
 * The Section that deals with showing the Action Element properties for the Automatic Task Node.
 * The Action Element can be a handler or a script.
 * 
 * @author Vijay Silva
 */
public class WPAutomaticTaskNodeActionSection extends AbstractPropertySection
{
	private TaskNodeActionElementComposite actionElementComposite;

	private AutomaticTaskNode taskNode;

	/**
	 * @see org.eclipse.ui.views.properties.tabbed.AbstractPropertySection#createControls(org.eclipse.swt.widgets.Composite,
	 *      org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage)
	 */
	@Override
	public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage)
	{
		super.createControls(parent, aTabbedPropertySheetPage);

		Composite clientArea = this.getWidgetFactory().createFlatFormComposite(parent);
		this.actionElementComposite = new TaskNodeActionElementComposite(clientArea, this.getWidgetFactory());
	}

	/**
	 * @see org.eclipse.ui.views.properties.tabbed.AbstractPropertySection#setInput(org.eclipse.ui.IWorkbenchPart,
	 *      org.eclipse.jface.viewers.ISelection)
	 */
	@Override
	public void setInput(IWorkbenchPart part, ISelection selection)
	{
		super.setInput(part, selection);

		if (!(selection instanceof IStructuredSelection))
			return;

		SemanticElement element = Utility.getSemanticElement(selection);

		if (element instanceof AutomaticTaskNode)
		{
			this.taskNode = (AutomaticTaskNode) element;
			refresh();
		}
	}

	/**
	 * @see org.eclipse.ui.views.properties.tabbed.AbstractPropertySection#refresh()
	 */
	@Override
	public void refresh()
	{
		super.refresh();

		this.actionElementComposite.setTaskNode(this.taskNode);
	}

	/**
	 * @see org.eclipse.ui.views.properties.tabbed.AbstractPropertySection#shouldUseExtraSpace()
	 */
	@Override
	public boolean shouldUseExtraSpace()
	{
		return true;
	}

}
