/**
 * 
 */
package com.tandbergtv.watchpoint.studio.ui.properties.filter;

import org.jbpm.gd.common.model.SemanticElement;

import com.tandbergtv.watchpoint.studio.dto.NodeDefinitionType;
import com.tandbergtv.watchpoint.studio.ui.model.NodeDefinition;

/**
 * Filter for Super-State Node Definitions.
 * 
 * @author Imran Naqvi
 * 
 */
public class SuperStateNodeDefinitionContainerFilter extends WPPropertyFilter {

	/**
	 * @see com.tandbergtv.watchpoint.studio.ui.properties.filter.WPPropertyFilter#selectModelElement(org.jbpm.gd.common.model.SemanticElement)
	 */
	@Override
	protected boolean selectModelElement(SemanticElement modelElement) {
		/*
		 * If model is null then we don't want to show anything in properties view. This happens
		 * when user click on the xml source tab of the editor.
		 */
		if (modelElement == null)
			return false;

		/*modelElement must be a NodeDefinition and its type must be SuperState*/
		return modelElement instanceof NodeDefinition
				&& ((NodeDefinition) modelElement).getNodeType() == NodeDefinitionType.SuperState;
	}

}
