/**
 * 
 */
package com.tandbergtv.watchpoint.studio.ui.properties.template;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.jbpm.gd.common.model.SemanticElement;

import com.tandbergtv.watchpoint.studio.ui.model.IProtectionKeyElement;
import com.tandbergtv.watchpoint.studio.ui.util.Utility;

/**
 * Property section for viewing/setting the protection keys of an element.
 * 
 * @author Imran Naqvi
 * 
 */
public class PKContainerSection extends AbstractPropertySection {

	private PKContainerConfigurationComposite pkContainerConfigurationComposite;

	private IProtectionKeyElement protectionKeyElement;

	/**
	 * @see org.eclipse.ui.views.properties.tabbed.AbstractPropertySection#createControls(org.eclipse.swt.widgets.Composite,
	 *      org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage)
	 */
	public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
		super.createControls(parent, aTabbedPropertySheetPage);
		Composite clientArea = getWidgetFactory().createFlatFormComposite(parent);
		pkContainerConfigurationComposite = PKContainerConfigurationComposite.create(this, 
				getWidgetFactory(), clientArea);
	}

	/**
	 * @see org.eclipse.ui.views.properties.tabbed.AbstractPropertySection#setInput(org.eclipse.ui.IWorkbenchPart,
	 *      org.eclipse.jface.viewers.ISelection)
	 */
	public void setInput(IWorkbenchPart part, ISelection selection) {
		super.setInput(part, selection);

		if (!(selection instanceof IStructuredSelection))
			return;

		SemanticElement element = Utility.getSemanticElement(selection);
		if (element instanceof IProtectionKeyElement) {
			setProtectionKeyElement((IProtectionKeyElement) element);
		}
	}

	/**
	 * @see org.eclipse.ui.views.properties.tabbed.AbstractPropertySection#refresh()
	 */
	public void refresh() {
		if (protectionKeyElement != null) {
			pkContainerConfigurationComposite.setProtectionKeyElement(protectionKeyElement);
		}
	}

	/*
	 * Sets the node definition. @param describableElement
	 */
	private void setProtectionKeyElement(IProtectionKeyElement protectionKeyElement) {
		this.protectionKeyElement = protectionKeyElement;
	}
}
