/**
 * IDiff.java
 * Created Apr 12, 2010
 */
package com.tandbergtv.watchpoint.studio.ui.sync;

import org.jbpm.gd.common.model.SemanticElement;

import com.tandbergtv.watchpoint.studio.dto.IWatchPointDTO;

/**
 * Represents a delta between the existing, or local, model object and its remote version. The delta
 * is applicable to the semantic element and potentially to one of its properties.
 * 
 * @author Sahil Verma
 */
public interface IDiff {
	
	/**
	 * The model object that has changes
	 * 
	 * @return
	 */
	IWatchPointDTO getModel();
	
	/**
	 * UI representation of the model that has changes
	 * 
	 * @return
	 */
	SemanticElement getElement();
	
	/**
	 * The attribute, or property of a model that differs
	 * 
	 * @return
	 */
	String getAttribute();
	
	/**
	 * Gets the type of this diff
	 * 
	 * @return
	 */
	DiffKind getKind();
}
