/**
 * AddVariableCommand.java
 * Created Apr 21, 2010
 */
package com.tandbergtv.watchpoint.studio.ui.sync.template;

import static com.tandbergtv.watchpoint.studio.dto.NodeDefinitionType.MessageNode;

import org.jbpm.gd.jpdl.model.NodeElement;

import com.tandbergtv.watchpoint.studio.dto.NodeDefinitionType;
import com.tandbergtv.watchpoint.studio.ui.model.IMessageContainer;
import com.tandbergtv.watchpoint.studio.ui.model.NodeDefinition;
import com.tandbergtv.watchpoint.studio.ui.model.WPVariable;
import com.tandbergtv.watchpoint.studio.ui.model.WorkflowTemplate;
import com.tandbergtv.watchpoint.studio.ui.sync.IDiff;
import com.tandbergtv.watchpoint.studio.ui.sync.util.ISynchronizationContext;

/**
 * Adds a variable to a template's node 
 * 
 * @author Sahil Verma
 */
public class AddVariableCommand extends AbstractVariableCommand {

	/**
	 * The UI model of the node that contains the new variable. This node is being updated.
	 */
	protected NodeDefinition node;

	/**
	 * Creates an {@link AddVariableCommand}
	 * 
	 * @param name
	 * @param diff
	 * @param context
	 */
	public AddVariableCommand(String name, IDiff diff, ISynchronizationContext context) {
		super(name, diff, context);
	}

	/**
	 * @return the node
	 */
	public NodeDefinition getNode() {
		return node;
	}

	/**
	 * @param node the node to set
	 */
	public void setNode(NodeDefinition node) {
		this.node = node;
	}

	/**
	 * {@inheritDoc}
	 */
	public void execute() {
		WorkflowTemplate template = (WorkflowTemplate) container;
		
		/* The template could contain several instances of the node definition, go through all of them */
		for (NodeElement element : template.findNodes(this.node.getId())) {
			NodeDefinition node = (NodeDefinition) element;

			if (variable.isCompositeKey())
				addCompositeKey(node);
			else
				/* Clone the variable before adding it to a node, otherwise it will get added 
				 * to only one node in the template. */
				addVariable(node, this.variable.cloneVariable());
		}
	}
	
	/**
	 * Adds the variable to the given node in the template
	 * 
	 * @param node
	 * @param variable
	 */
	protected void addVariable(NodeDefinition node, WPVariable variable) {
		if (node.getNodeType() == MessageNode)
			((IMessageContainer) node.getNode()).addVariable(variable);
		else
			node.addVariable(variable);
	}
	
	protected void addCompositeKey(NodeDefinition node) {
		if (node.getNodeType() == NodeDefinitionType.MessageNode)
			node.setCompositeKey(variable.getMappedName(), variable.getMappedName());
	}
}
