package com.tandbergtv.watchpoint.studio.ui.view.resourcetype.actions;

import static com.tandbergtv.watchpoint.studio.service.ServiceFactory.createFactory;
import static org.eclipse.jface.dialogs.MessageDialog.openError;
import static org.eclipse.swt.widgets.Display.getCurrent;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.window.Window;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

import com.tandbergtv.watchpoint.studio.dto.Message;
import com.tandbergtv.watchpoint.studio.dto.NodeDefinitionDTO;
import com.tandbergtv.watchpoint.studio.dto.ResourceType;
import com.tandbergtv.watchpoint.studio.service.IResourceTypeService;
import com.tandbergtv.watchpoint.studio.service.ServiceException;
import com.tandbergtv.watchpoint.studio.ui.editor.resourcetype.formpart.MessageMasterSectionPart;
import com.tandbergtv.watchpoint.studio.ui.util.ServiceErrors;
import com.tandbergtv.watchpoint.studio.ui.util.Utility;
import com.tandbergtv.watchpoint.studio.ui.wizard.MessageWizard;

public class CreateMessageAction extends AbstractNodeDefinitionAction{
	private ResourceType resourceType;
	
	@Override
	public void run(IAction action) {
		IWorkbench workbench = PlatformUI.getWorkbench();
		
		MessageWizard messageWizard = new MessageWizard(resourceType);
		WizardDialog dialog = new WizardDialog(workbench
				.getActiveWorkbenchWindow().getShell(), messageWizard);
		
		dialog.open();

		if (dialog.getReturnCode() != Window.OK)
			return;

		String timeout = messageWizard.getTimeout();
		Message message = messageWizard.getMessage();
		
		resourceType.addMessage(message);
		
		try {
			NodeDefinitionDTO dto = MessageMasterSectionPart.createInitialDTO(resourceType, message, timeout);
			createFactory().createNodeDefinitionService().createNodeDefinitionInFileSystem(dto);

			IResourceTypeService rtService = createFactory().createResourceTypeService();

			rtService.updateResourceTypeInFileSystem(resourceType);

			ResourceType updated = rtService.getResourceTypeFromFileSystem(resourceType.getProjectName());

			if (updated == null) {
				Utility.reportError("Error updating resource type", null);
			} 
		} catch (ServiceException e) {
			handleException(ServiceErrors.getInstance().getProperty(e.getServiceErrorCode().getCode()), e);
		} catch (Exception e) {
			handleException("Error creating message node", e);
			openError(getCurrent().getActiveShell(), "Error", "Failed to create Message Node");
			return;
		}
		
		getTreeViewer().refresh(resourceType);
	}
	
	@Override
	public void selectionChanged(IAction action, ISelection selection) {
		if(!selection.isEmpty()){
			TreePath[] paths = ((TreeSelection) selection).getPaths();
			TreePath path = (paths != null) ? paths[0] : null;
			if(path != null){
				this.resourceType = (ResourceType) path.getSegment(1);
			}
		}
	}
	
}
