package com.tandbergtv.watchpoint.studio.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;

import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;

import org.eclipse.wst.xml.core.internal.contentmodel.CMDocument;
import org.eclipse.wst.xml.core.internal.contentmodel.util.DOMContentBuilder;
import org.eclipse.wst.xml.core.internal.contentmodel.util.NamespaceInfo;
import org.eclipse.wst.xml.ui.internal.wizards.NewXMLGenerator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

@SuppressWarnings("restriction")
public class MessageXMLGenerator {

	public static ByteArrayOutputStream createInitialVarMappingFile(
			String schemaUri, String rootElement) throws Exception {
		ByteArrayOutputStream createdDocument = null;
		if(rootElement != null){
			String[] errorInfo = new String[2];

			CMDocument cmDocument = NewXMLGenerator.createCMDocument(schemaUri,
					errorInfo);
			NewXMLGenerator generator = new NewXMLGenerator(schemaUri, cmDocument);
			generator.setRootElementName(rootElement);

			generator.setBuildPolicy(DOMContentBuilder.BUILD_OPTIONAL_ATTRIBUTES
					| DOMContentBuilder.BUILD_OPTIONAL_ELEMENTS
					| DOMContentBuilder.BUILD_FIRST_CHOICE
					| DOMContentBuilder.BUILD_FIRST_SUBSTITUTION
					| DOMContentBuilder.BUILD_TEXT_NODES);
			
			generator.createNamespaceInfoList();
			
			// Provide namespace prefix 
			for (int i = 0; i < generator.namespaceInfoList.size(); i++) {
				NamespaceInfo nsinfo = (NamespaceInfo) generator.namespaceInfoList.get(i);
					nsinfo.prefix = "ns" + i;
			}

			createdDocument = generator.createXMLDocument("test.xml",
					"UTF-8");
		}else{
			DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
			Document doc = factory.newDocumentBuilder().newDocument();
			createdDocument = XMLDocumentUtility.createByteArray(doc);
		}
		
		return createdDocument;
	}

	public static ByteArrayOutputStream createInitialXPathMappingFile()
			throws ParserConfigurationException, TransformerException,
			IOException {
		ByteArrayOutputStream baos = null;
		DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
		Document doc = factory.newDocumentBuilder().newDocument();

		// Root element 'xPathConfiguration'
		Element rootNode = doc.createElement("xPathConfiguration");
		doc.appendChild(rootNode);

		baos = XMLDocumentUtility.createByteArray(doc);

		return baos;
	}
	
	public static ByteArrayOutputStream createMessageAdaptorFile( 
			String messageUid, String resourceTypeName, String messageType, 
			String handlerClass, String dispatcherClass)
			throws ParserConfigurationException, TransformerException, IOException {
		
		DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
		Document doc = factory.newDocumentBuilder().newDocument();

		// Root element 'message'
		Element rootNode = doc.createElement("message");
		rootNode.setAttribute("UID", messageUid);
		rootNode.setAttribute("name", resourceTypeName);
		doc.appendChild(rootNode);
		
		// 'handler' Element
		Element handler = doc.createElement("handler");
		rootNode.appendChild(handler);
		
		// handler 'parameter' Element
		Element handlerNameParam = createAdaptorParameterElement(doc, "CLASS_NAME", handlerClass); 
		handler.appendChild(handlerNameParam);
		
		// 'dispatcher' Element
		Element dispatcher = doc.createElement("dispatcher"); 
		rootNode.appendChild(dispatcher);
		if(messageType.equals("outgoing")){
			addDispatcherParameters(doc, dispatcher, dispatcherClass);
		}
		ByteArrayOutputStream baos = XMLDocumentUtility.createByteArray(doc);

		return baos;
	}
	
	private static void addDispatcherParameters(Document doc, Element dispatcher, String dispatcherClass){
		dispatcher.appendChild(createAdaptorParameterElement(doc, "CLASS_NAME", dispatcherClass));
		dispatcher.appendChild(createAdaptorParameterElement(doc, "CONTENT_TYPE", "text/xml; charset=utf-8"));
	}
	
	private static Element createAdaptorParameterElement(Document doc,
			String parameterName, String parameterValue){
		Element parameter = doc.createElement("parameter");
		parameter.setAttribute("name", parameterName);
		parameter.setAttribute("value", parameterValue);
		
		return parameter;
	}

	public static ByteArrayOutputStream createWPCLMessageXMLFile(
			String messageUid, ArrayList<String> variables)
			throws ParserConfigurationException, TransformerException,
			IOException {
		DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
		Document doc = factory.newDocumentBuilder().newDocument();

		// Root element 'WFSMessage'
		Element rootNode = doc.createElement("WFSMessage");
		rootNode.setAttribute("Type", "ack");
		rootNode.setAttribute("UID", messageUid);
		rootNode.setAttribute("RequestKey", "");
		doc.appendChild(rootNode);

		if (variables != null && !variables.isEmpty()) {
			// 'MessageBody' Element
			Element messageBody = doc.createElement("MessageBody");
			rootNode.appendChild(messageBody);

			// 'ParameterList' Element
			Element parameterList = doc.createElement("ParameterList");
			messageBody.appendChild(parameterList);

			// 'Parameter' Elements
			for (String variableName : variables) {
				Element parameter = createWPCLParameterElement(doc, variableName);
				parameterList.appendChild(parameter);
			}
		}
		ByteArrayOutputStream baos = XMLDocumentUtility.createByteArray(doc);
		return baos;
	}

	public static ByteArrayOutputStream createInitialWPCLMessage(String messageUid) 
					throws ParserConfigurationException, TransformerException, IOException {
		return createWPCLMessageXMLFile(messageUid, null);
	}

	private static Element createWPCLParameterElement(Document doc,
			String variableName) {
		Element parameter = doc.createElement("Parameter");
		parameter.setAttribute("Name", variableName);
		Element value = doc.createElement("Value");
		Text placeHolderValue = doc.createTextNode("placeholder");
		value.appendChild(placeHolderValue);
		parameter.appendChild(value);

		return parameter;
	}

}
