/*
 * Created on Nov 15, 2007
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.watchpoint.studio.validation.model;

import org.jbpm.gd.common.model.GenericElement;
import org.jbpm.gd.jpdl.model.NodeElement;

import com.tandbergtv.watchpoint.studio.ui.actionconfig.ActionVariableConfiguration;
import com.tandbergtv.watchpoint.studio.ui.model.AutomaticTaskNode;

/**
 * Validation Model element that represents a 'Generic Element' variable added to an Action class.
 * 
 * @author Vijay Silva
 */
public class ActionVariable
{
	NodeElement node;

	GenericElement element;

	ActionVariableConfiguration configuration;

	/**
	 * Used to create a plain Action Variable without attaching it to a node. Simply contains the
	 * name of the variable.
	 * 
	 * @param element
	 *            The Generic Element representing the variable
	 */
	public ActionVariable(GenericElement element)
	{
		this(null, element, null);
	}

	/**
	 * @param node
	 *            The Node containing the Action Class Variable.
	 * @param element
	 *            The Generic Element containing the variable name and value.
	 * @param variableConfiguration
	 *            The Configuration of the variable.
	 */
	public ActionVariable(AutomaticTaskNode node, GenericElement element,
			ActionVariableConfiguration variableConfiguration)
	{
		this.node = node;
		this.element = element;
		this.configuration = variableConfiguration;
	}

	/**
	 * @return the node
	 */
	public NodeElement getNode()
	{
		return this.node;
	}

	/**
	 * @return the element containing the variable
	 */
	public GenericElement getElement()
	{
		return this.element;
	}

	/**
	 * @return the configuration for the variable
	 */
	public ActionVariableConfiguration getConfiguration()
	{
		return this.configuration;
	}
}
