package com.tandbergtv.watchpoint.studio.validation.rules.nodeelement.loopnode;

import java.util.ArrayList;
import java.util.List;

import com.tandbergtv.watchpoint.studio.ui.model.LoopNode;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessage;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageCode;
import com.tandbergtv.watchpoint.studio.validation.ValidationRule;
import com.tandbergtv.watchpoint.studio.validation.impl.ValidationMessageAdder;

public class LoopNodeChildNodeRequired extends ValidationRule<LoopNode>{

	@Override
	public List<ValidationMessage> validateRule(LoopNode target) {
		List<ValidationMessage> messages = new ArrayList<ValidationMessage>();
		
		if (target.getNodeElements().length <= 0){
		    ValidationMessageAdder.getInstance().addValidationMessage(messages, target, ValidationMessageCode.LOOPNODE_NO_CHILD);
		}
		
		return messages;
	}

}
