package com.tandbergtv.watchpoint.studio.validation.rules.nodeelement.loopnode;

import java.util.ArrayList;
import java.util.List;

import org.jbpm.gd.jpdl.model.NodeElementContainer;
import org.jbpm.gd.jpdl.model.Variable;

import com.tandbergtv.watchpoint.studio.ui.model.LoopNode;
import com.tandbergtv.watchpoint.studio.ui.model.LoopNodeType;
import com.tandbergtv.watchpoint.studio.ui.model.NodeDefinition;
import com.tandbergtv.watchpoint.studio.ui.model.WPVariable;
import com.tandbergtv.watchpoint.studio.ui.model.WorkflowTemplate;
import com.tandbergtv.watchpoint.studio.ui.properties.DataType;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessage;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageCode;
import com.tandbergtv.watchpoint.studio.validation.ValidationRule;
import com.tandbergtv.watchpoint.studio.validation.impl.ValidationMessageAdder;
import com.tandbergtv.watchpoint.studio.validation.model.TemplateLoopNodeInstance;

public class LoopNodeVariablesValidation extends ValidationRule<TemplateLoopNodeInstance>{

	@Override
	public List<ValidationMessage> validateRule(TemplateLoopNodeInstance target) {
		List<ValidationMessage> messages = new ArrayList<ValidationMessage>();
		
		messages.addAll(checkIfVariablesExists(target.getNodeInstance()));
		messages.addAll(checkVariablesType(target));
		
		return messages;
	}
	
	public List<ValidationMessage> checkIfVariablesExists(LoopNode loopNode){
		List<ValidationMessage> messages = new ArrayList<ValidationMessage>();
		String indexValue = loopNode.getIndex();
		/* Check if the loop node has the index variable assigned */
		if(indexValue == null || indexValue.isEmpty()){
			ValidationMessageAdder.getInstance().addValidationMessage(messages, loopNode, ValidationMessageCode.LOOPNODE_MISSING_INDEX_VARIABLE);
		}
		/* Check if the loop node has the list variable assigned */
		if( LoopNodeType.FOR_EACH.equals(loopNode.getLoopType()) ){
			String listName = loopNode.getListName();
			if(listName == null || listName.isEmpty()){
				ValidationMessageAdder.getInstance().addValidationMessage(messages, loopNode, ValidationMessageCode.LOOPNODE_MISSING_LIST_VARIABLE);
			}
		}
		return messages;
	}
	
	public List<ValidationMessage> checkVariablesType(TemplateLoopNodeInstance target){
		List<ValidationMessage> messages = new ArrayList<ValidationMessage>();
		
		Variable[] variables = null;
		
		if(target.getContainer() instanceof WorkflowTemplate){
			variables = getContainerVariables( (WorkflowTemplate)target.getContainer() );
		} else if(target.getContainer() instanceof NodeDefinition){
			variables = getContainerVariables( (NodeDefinition)target.getContainer() );
		} 
		
		LoopNode loopNode = target.getNodeInstance();
		
		/* Check if the loop node index and list match the appropriate type */
		for (Variable variable : variables) {
			WPVariable v = (WPVariable) variable;
			DataType type = DataType.STRING;
			
			if (v.getType() != null)
				type = DataType.valueOf(v.getType());
			
			String variableName = variable.getName();
			if( variableName != null && variableName.equals(loopNode.getIndex()) ){
				/* Check if the index is a variable of type integer */
				if( type != DataType.INT ){
				    ValidationMessageAdder.getInstance().addValidationMessage(messages, loopNode, ValidationMessageCode.LOOPNODE_INDEX_WRONG_TYPE);
				}
			} else if( variableName != null && variableName.equals(loopNode.getListName()) ){
				/* Check if the list is a variable of type LIST */
				if( type != DataType.LIST ){
					ValidationMessageAdder.getInstance().addValidationMessage(messages, loopNode, ValidationMessageCode.LOOPNODE_LIST_WRONG_TYPE);
				}
			}
		}
			
		return messages;
	}
	
	Variable[] getContainerVariables(NodeElementContainer container){
		Variable[] variables = new Variable[0];
		if(container instanceof WorkflowTemplate){
			WorkflowTemplate template = (WorkflowTemplate)container;
			if( template.getStartState() != null && template.getStartState().getTask() != null &&
					template.getStartState().getTask().getController() != null){
				/* Get the start state variables */
				variables = template.getStartState().getTask().getController().getVariables();
			}
		}else if(container instanceof NodeDefinition){
			NodeDefinition nodeDefinition = (NodeDefinition)container;
			variables = nodeDefinition.getVariables().toArray(new Variable[0]);
		}
		return variables;
	}
	
}
