package com.tandbergtv.watchpoint.studio.validation.rules.nodeelement.startstate;

import java.util.ArrayList;
import java.util.List;

import org.jbpm.gd.jpdl.model.StartState;

import com.tandbergtv.watchpoint.studio.ui.model.WPVariable;
import com.tandbergtv.watchpoint.studio.ui.util.ModelHandler;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessage;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageCode;
import com.tandbergtv.watchpoint.studio.validation.ValidationRule;
import com.tandbergtv.watchpoint.studio.validation.impl.ValidationMessageAdder;

public class ValidVariableNamesRule extends ValidationRule<StartState> {

    @Override
    public List<ValidationMessage> validateRule(StartState target) {
        List<ValidationMessage> messages = new ArrayList<ValidationMessage>();

        for (WPVariable variable : ModelHandler.getStartStateVariables(target)) {
            if (!variable.isNameValid()) {
                List<String> parameters = new ArrayList<String>();
                parameters.add(variable.getName());
                ValidationMessageAdder.getInstance().addValidationMessage(messages, target,
                        ValidationMessageCode.TEMPLATE_START_NODE_VARIABLE_NAME_INVALID, parameters);
            }
        }

        return messages;
    }
}
