/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.debugger.core;

import com.tandbergtv.watchpoint.studio.debugger.core.DataType;
import com.tandbergtv.watchpoint.studio.debugger.core.TypeConversionException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;

public class DatatypeConverter {
    private static final String DATE_FORMAT = "yyyy-MM-dd";
    private DateFormat dateformat = new SimpleDateFormat("yyyy-MM-dd");

    public Object convert(Object input, DataType type) throws TypeConversionException {
        if (input == null) {
            throw new IllegalArgumentException("Input cannot be null");
        }
        Cloneable ret = input.toString();
        try {
            switch (type) {
                case INT: {
                    ret = Integer.valueOf(input.toString());
                    break;
                }
                case BOOLEAN: {
                    ret = Boolean.valueOf(input.toString());
                    break;
                }
                case DATE: {
                    ret = this.dateformat.parse(input.toString());
                    break;
                }
                case DURATION: {
                    break;
                }
                case LIST: {
                    ret = this.toList(input);
                    break;
                }
            }
        }
        catch (Exception e) {
            throw new TypeConversionException("Failed to convert " + input + " to type " + (Object)((Object)type), e);
        }
        return ret;
    }

    private ArrayList<?> toList(Object input) {
        if (input instanceof String) {
            if (input.toString().isEmpty()) {
                return null;
            }
            String[] strings = ((String)String.class.cast(input)).split(",");
            int i = 0;
            while (i < strings.length) {
                strings[i] = strings[i].trim();
                ++i;
            }
            return new ArrayList<String>(Arrays.asList(strings));
        }
        return (ArrayList)input;
    }
}

