/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.debugger.core.graph;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.dom4j.Element;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.def.SuperState;
import org.jbpm.graph.def.Transition;
import org.jbpm.jpdl.xml.JpdlXmlReader;

public class SuperState2
extends SuperState {
    private static final long serialVersionUID = 1214915925481664560L;
    private Long resourceGroupID;
    private String duration;
    private String taskDuration;
    private static final Long DEFAULT_RESOURCE_GROUP_ID = -1L;

    public List<Node> getNodes() {
        return super.getNodes();
    }

    public String getDuration() {
        return this.duration;
    }

    public void setDuration(String duration) {
        this.duration = duration;
    }

    public Long getResourceGroupID() {
        if (this.resourceGroupID.equals(DEFAULT_RESOURCE_GROUP_ID)) {
            return null;
        }
        return this.resourceGroupID;
    }

    public void setResourceGroupID(Long resourceGroupID) {
        this.resourceGroupID = resourceGroupID == null ? DEFAULT_RESOURCE_GROUP_ID : resourceGroupID;
    }

    public String getTaskDuration() {
        return this.taskDuration;
    }

    public void setTaskDuration(String taskDuration) {
        this.taskDuration = taskDuration;
    }

    public void read(Element element, JpdlXmlReader jpdlReader) {
        this.action = jpdlReader.readSingleAction(element);
        this.setDuration(element.attributeValue("duration"));
        this.setTaskDuration(element.attributeValue("taskDuration"));
        super.read(element, jpdlReader);
    }

    public Node first() {
        for (Object obj : this.nodes) {
            Node node = (Node)obj;
            if (node.getArrivingTransitions() == null || node.getArrivingTransitions().isEmpty()) {
                return node;
            }
            for (Object transObj : node.getArrivingTransitions()) {
                Transition transition = (Transition)transObj;
                SuperState superstate = transition.getFrom().getSuperState();
                if (superstate != null && superstate.equals((Object)this)) continue;
                return node;
            }
        }
        return null;
    }

    public Node last() {
        return (Node)this.nodes.get(this.nodes.size() - 1);
    }

    public List<?> getLeavingTransitions() {
        ArrayList<Transition> list = new ArrayList<Transition>();
        for (Node child : this.getNodes()) {
            if (child.getLeavingTransitions() == null) continue;
            for (Transition transition : child.getLeavingTransitions()) {
                if (this.equals(transition.getTo().getSuperState())) continue;
                list.add(transition);
            }
        }
        return list;
    }

    public Set<?> getArrivingTransitions() {
        HashSet<Transition> set = new HashSet<Transition>();
        Node first = this.first();
        if (first.getArrivingTransitions() == null) {
            return set;
        }
        for (Object obj : first.getArrivingTransitions()) {
            Transition transition = (Transition)Transition.class.cast(obj);
            if (this.equals(transition.getFrom().getSuperState())) continue;
            set.add(transition);
        }
        return set;
    }
}

