/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.debugger.runtime.debug;

import com.tandbergtv.watchpoint.studio.debugger.runtime.Services;
import com.tandbergtv.watchpoint.studio.debugger.runtime.debug.Breakpoint;
import com.tandbergtv.watchpoint.studio.debugger.runtime.debug.NodeFinder;
import com.tandbergtv.workflow.core.AutomaticTaskNode;
import com.tandbergtv.workflow.core.NodeGroup;
import com.tandbergtv.workflow.core.ProcessPriority;
import com.tandbergtv.workflow.core.ProcessStatus;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.core.WorkflowTemplate;
import com.tandbergtv.workflow.core.graph.IProcessFactory;
import com.tandbergtv.workflow.core.graph.NodeVisitor;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.core.service.cache.ICacheService;
import com.tandbergtv.workflow.driver.DriverException;
import com.tandbergtv.workflow.driver.service.IProcessManagerService;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.jbpm.JbpmConfiguration;
import org.jbpm.graph.def.Action;
import org.jbpm.graph.def.GraphElement;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.graph.def.Transition;
import org.jbpm.graph.exe.RuntimeAction;
import org.jbpm.instantiation.Delegation;

public class Commands {
    private static final Logger logger = Logger.getLogger(Commands.class);

    public static WorkflowProcess create(ProcessDefinition template, Map<String, Object> parameters) {
        IProcessFactory factory = (IProcessFactory)JbpmConfiguration.Configs.getObject((String)"jbpm.process.factory");
        WorkflowProcess process = factory.create(template, ProcessPriority.NORMAL, parameters);
        process.getRuntimeActions().clear();
        return process;
    }

    public static WorkflowProcess find() {
        ICacheService<WorkflowProcess> cache = Commands.getCache();
        for (Serializable id : cache.getKeys()) {
            WorkflowProcess process = (WorkflowProcess)cache.get(id);
            if (process.getSuperProcessToken() != null) continue;
            return process;
        }
        throw new RuntimeException();
    }

    public static Node findNode(WorkflowTemplate template, String name) {
        NodeFinder visitor = new NodeFinder(name);
        template.depthFirstTraversal((NodeVisitor)visitor);
        return visitor.getTarget();
    }

    public static void addBreakpoint(WorkflowProcess process, Node node) {
        if (!(node instanceof AutomaticTaskNode) && !(node instanceof NodeGroup)) {
            return;
        }
        Set transitions = node.getArrivingTransitions();
        if (transitions == null || transitions.isEmpty()) {
            return;
        }
        for (Object obj : transitions) {
            Transition t = (Transition)obj;
            Action action = new Action(new Delegation(Breakpoint.class.getName()));
            process.addRuntimeAction(new RuntimeAction((GraphElement)t, "transition", action));
        }
        logger.info((Object)(process.getRootToken() + ", set breakpoint at " + node.getName()));
    }

    public static void removeBreakpoint(WorkflowProcess process, Node node) {
        Set transitions = node.getArrivingTransitions();
        if (transitions == null || transitions.isEmpty()) {
            return;
        }
        for (Object obj : transitions) {
            Transition t = (Transition)obj;
            Iterator i = process.getRuntimeActions().iterator();
            while (i.hasNext()) {
                RuntimeAction action = (RuntimeAction)i.next();
                if (action.getGraphElement() != t || !action.getEventType().equals("transition")) continue;
                i.remove();
            }
        }
        logger.info((Object)(process.getRootToken() + ", removed breakpoint at " + node.getName()));
    }

    public static void suspend(WorkflowProcess process) {
        process.getRootToken().suspend();
    }

    public static void resume(WorkflowProcess process) throws DriverException {
        if (process.getRootToken().getStatus() == ProcessStatus.CREATED) {
            Services.getService(IProcessManagerService.class).start(process.getRootToken());
        } else {
            Services.getService(IProcessManagerService.class).resume(process.getRootToken());
        }
    }

    private static ICacheService<WorkflowProcess> getCache() {
        return (ICacheService)ServiceRegistry.getDefault().lookup("Process Cache");
    }
}

