/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.debugger.runtime.output;

import com.tandbergtv.watchpoint.studio.debugger.core.graph.Decision2;
import com.tandbergtv.watchpoint.studio.debugger.core.graph.Loop2;
import com.tandbergtv.watchpoint.studio.debugger.core.graph.SuperState2;
import com.tandbergtv.watchpoint.studio.debugger.model.SimulationType;
import com.tandbergtv.watchpoint.studio.debugger.runtime.exception.NodeSimulationException;
import com.tandbergtv.watchpoint.studio.debugger.runtime.nodesimulation.MailNodeSimulator;
import com.tandbergtv.watchpoint.studio.debugger.runtime.nodesimulation.NodeSimulator;
import com.tandbergtv.watchpoint.studio.debugger.runtime.output.TemplateSimulationOutputWriter;
import com.tandbergtv.workflow.core.MailNode;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jbpm.context.def.VariableAccess;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.graph.def.Transition;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.graph.node.Decision;
import org.jbpm.graph.node.StartState;
import org.jbpm.graph.node.TaskNode;
import org.jbpm.taskmgmt.def.Task;

public class StringToOutputStreamSimulationWriter
extends TemplateSimulationOutputWriter {
    protected PrintWriter out;
    private static final String SECTION_SEPARATOR = "----------------------------------------------------";
    private static final String IDENT = "    ";

    public StringToOutputStreamSimulationWriter(PrintWriter printWriter) {
        this.out = printWriter;
    }

    @Override
    public void templateSimulationStarted(ExecutionContext context, ProcessDefinition template) {
        this.out.println(SECTION_SEPARATOR);
        this.out.println("Starting simulation for: " + template.getName());
        this.out.println(SECTION_SEPARATOR);
        this.out.flush();
    }

    @Override
    public void templateSimulationCompleted(ExecutionContext context, ProcessDefinition template) {
        this.out.println();
        this.out.println(SECTION_SEPARATOR);
        this.out.println("Ending simulation for: " + template.getName());
        Map variables = context.getContextInstance().getVariables(context.getToken());
        this.printVariables(variables);
        this.out.println(SECTION_SEPARATOR);
        this.out.close();
    }

    @Override
    public void nodeSimulationStarted(ExecutionContext context, Node node, NodeSimulator simulator) {
        this.out.println();
        this.out.println(SECTION_SEPARATOR);
        if (node.getSuperState() instanceof SuperState2) {
            node = node.getSuperState();
        }
        this.out.println("Node: " + node.getName());
        this.out.println(SECTION_SEPARATOR);
        if (simulator != null && simulator.getSimulationConfig() != null) {
            this.out.print(this.getIdentation(1));
            this.out.println("Simulation Type: " + (Object)((Object)simulator.getSimulationConfig().getSimulationType()));
            this.printNodeSpecificData(context, node, simulator);
            if (!(node instanceof StartState)) {
                this.printInputVariables(context, simulator.getVariables());
            }
        }
        this.out.flush();
    }

    @Override
    public void nodeSimulationCompleted(ExecutionContext context, Node node, NodeSimulator simulator) {
        List<?> transitions;
        if (simulator != null && simulator.getSimulationConfig() != null && !SimulationType.SKIP_NODE.equals((Object)simulator.getSimulationConfig().getSimulationType())) {
            if (simulator.getVariables() != null && !simulator.getVariables().isEmpty()) {
                this.printOutputVariables(context, simulator.getVariables());
            }
            if (simulator.fail()) {
                this.printFail(simulator.getException());
            }
        }
        if ((transitions = node.getLeavingTransitions()) != null && transitions.size() > 1) {
            if (simulator != null) {
                transitions = simulator.getLeavingTransitions();
            }
            if (node instanceof Decision) {
                this.printTransitions(transitions);
            } else if (transitions != null && transitions.size() > 1) {
                this.printTransitions(transitions);
            }
        }
        if (node instanceof Loop2) {
            Loop2 loop = (Loop2)node;
            this.out.print(this.getIdentation(1));
            this.out.print("Index: ");
            this.out.println(context.getVariable(loop.getIndex()));
            this.out.print(this.getIdentation(1));
            this.out.print("Loop ?: ");
            this.out.println(loop.evaluateExpression(context));
        }
        if (node instanceof MailNode) {
            MailNodeSimulator mailSimulator = (MailNodeSimulator)simulator;
            this.out.print("To: ");
            this.out.println(mailSimulator.getTo());
            this.out.print(this.getIdentation(1));
            this.out.print("Subject: ");
            this.out.println(mailSimulator.getSubject());
            this.out.print(this.getIdentation(1));
            this.out.print("Body: ");
            this.out.println(mailSimulator.getText());
            this.out.print(this.getIdentation(1));
            this.out.print("Attachment: ");
            this.out.println(mailSimulator.getAttachment());
        }
        this.out.println(SECTION_SEPARATOR);
        this.out.flush();
    }

    protected void printNodeSpecificData(ExecutionContext context, Node node, NodeSimulator simulator) {
        if (SimulationType.EXECUTE.equals((Object)simulator.getSimulationConfig().getSimulationType())) {
            this.out.print(this.getIdentation(1));
            if (node instanceof Decision2) {
                Decision2 decision = (Decision2)node;
                this.out.print("Executing expression: ");
                this.out.println(decision.getDecisionExpression());
            }
            if (node instanceof Loop2) {
                Loop2 loop = (Loop2)node;
                this.out.print("Executing expression: ");
                this.out.println(loop.getExpression());
            }
            if (node instanceof TaskNode) {
                TaskNode taskNode = (TaskNode)node;
                Task task = node.getProcessDefinition().getTaskMgmtDefinition().getTask(node.getName());
                if (task == null) {
                    this.out.print("Executing class: ");
                    this.out.println(taskNode.getAction().getActionDelegation().getClassName());
                }
            }
        }
    }

    protected void printFail(NodeSimulationException nodeSimulationException) {
        this.out.print(this.getIdentation(1));
        if (nodeSimulationException == null) {
            this.out.println("Fail: true. Aborting execution.");
        } else {
            this.out.println();
            this.out.println("An error occurred while attempting to simulate node: " + nodeSimulationException.getNode().getName());
            this.out.println("Error: " + nodeSimulationException.getMessage());
            if (nodeSimulationException.getCause() != null) {
                this.out.println("Root cause: " + nodeSimulationException.getCause().getMessage());
            }
            this.out.println("StackTrace: ");
            nodeSimulationException.printStackTrace(this.out);
            this.out.println();
        }
    }

    protected void printTransitions(List<?> transitions) {
        for (Object t : transitions) {
            this.out.print(this.getIdentation(1));
            Transition transition = (Transition)t;
            this.out.println("Transition: " + transition.getName());
        }
    }

    protected void printVariable(int index, Object varName, Object varValue) {
        this.out.print(this.getIdentation(2));
        this.out.print(String.valueOf(index) + ". ");
        this.out.print(varName);
        this.out.print("=");
        if (varValue != null) {
            this.out.println(varValue);
        } else {
            this.out.println();
        }
    }

    protected void printVariables(Map<?, ?> variables) {
        if (variables != null && !variables.isEmpty()) {
            this.out.print(this.getIdentation(1));
            this.out.println("Variables: ");
            int i = 1;
            for (Object var : variables.keySet()) {
                this.printVariable(i, var, variables.get(var));
                ++i;
            }
        }
    }

    protected void printInputVariables(ExecutionContext context, Collection<VariableAccess> variables) {
        if (!variables.isEmpty()) {
            this.out.print(this.getIdentation(1));
            this.out.println("Input Variables: ");
            int i = 1;
            for (VariableAccess var : variables) {
                if (!var.isReadable()) continue;
                this.printVariable(i, var.getMappedName(), context.getVariable(var.getVariableName()));
                ++i;
            }
        }
    }

    protected void printOutputVariables(ExecutionContext context, Collection<VariableAccess> variables) {
        if (!variables.isEmpty()) {
            this.out.print(this.getIdentation(1));
            this.out.println("Output Variables: ");
            int i = 1;
            for (VariableAccess var : variables) {
                if (!var.isWritable()) continue;
                this.printVariable(i, var.getVariableName(), context.getVariable(var.getVariableName()));
                ++i;
            }
        }
    }

    protected void printVariables(ExecutionContext context, Collection<VariableAccess> variables) {
        this.out.print(this.getIdentation(1));
        this.out.println("Variables: ");
        int i = 1;
        for (VariableAccess var : variables) {
            this.printVariable(i, var.getVariableName(), context.getVariable(var.getVariableName()));
            ++i;
        }
    }

    private String getIdentation(int ammount) {
        StringBuilder builder = new StringBuilder(ammount);
        int i = 0;
        while (i < ammount) {
            builder.append(IDENT);
            ++i;
        }
        return builder.toString();
    }
}

