/**
 * TaskVariable.java
 * Created Jun 5, 2006
 * Copyright (C) Tandberg Television 2006
 */
package com.tandbergtv.watchpoint.studio.debugger.core;

import org.jbpm.context.def.VariableAccess;

/**
 * Extends the JBPM variable with a datatype
 * 
 * @author Sahil Verma
 */
public class VariableAccess2 extends VariableAccess {

	private static final long serialVersionUID = -3920818381338217077L;
	
	/* FIXME These should really be in an enum */
	public static final String ACCESS_LITERAL_WOKEY = "woKey";
	
	public static final String ACCESS_LITERAL_SHOW_IN_UI = "showInUI";
	
	private static final String ACCESS_ATTACHMENT = "attachment";
	
	private DataType datatype;
	
	private String initialValue;
	
	/**
	 * Creates a TaskVariable
	 */
	public VariableAccess2() {
		super();
	}

	/**
	 * Creates a TaskVariable
	 * @param variableName
	 * @param access
	 * @param mappedName
	 */
	public VariableAccess2(String variableName, String access, String mappedName, DataType datatype) {
		super(variableName, access, mappedName);
		this.datatype = datatype;
	}

	/**
	 * Creates a TaskVariable
	 * 
	 * @param variableName the name
	 * @param access the access permissions
	 * @param mappedName the mapped name
	 * @param datatype the data type
	 * @throws TypeConversionException 
	 */
	public VariableAccess2(String variableName, String access, String mappedName, DataType datatype, String initialValue) 
		throws TypeConversionException {
		super(variableName, access, mappedName);
		this.datatype = datatype;
		
		/* Validate */
		new DatatypeConverter().convert(initialValue, this.datatype);
		
		this.initialValue = initialValue;
	}
	
	/**
	 * @return Returns the datatype.
	 */
	public DataType getDatatype() {
		return this.datatype;
	}
	
	/**
	 * Returns true if this variable has a non-null value
	 * 
	 * @return
	 */
	public boolean hasValue() {
		return initialValue != null;
	}

	/**
	 * Returns true if the variable is an attachment
	 * @return
	 */
	public boolean isAttachment() {
		return access.hasAccess(ACCESS_ATTACHMENT);
	}
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	public String toString() {
		return "Name " + variableName + ", " + 
			"type " + datatype +
				(isRequired() ? ", required" : "") +
				(initialValue != null ? ", value " + initialValue : "");
	}
}
