/**
 * RuntimeLauncher.java
 * Created Aug 20, 2012
 */
package com.tandbergtv.watchpoint.studio.debugger.runtime;

import static com.tandbergtv.watchpoint.studio.debugger.launching.TemplateLauncherConstants.CONFIG;
import static com.tandbergtv.watchpoint.studio.debugger.runtime.debug.Commands.create;

import java.util.Map;

import org.apache.log4j.Logger;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.def.ProcessDefinition;

import com.tandbergtv.watchpoint.studio.debugger.model.NodeSimulationConfig;
import com.tandbergtv.watchpoint.studio.debugger.model.ParameterizableSimulationData;
import com.tandbergtv.watchpoint.studio.debugger.model.SimulationData;
import com.tandbergtv.workflow.core.WorkflowProcess;

/**
 * Launches the workflow execution runtime and spawns the process
 * 
 * @author Sahil Verma
 */
public class RuntimeLauncher extends TemplateSimulator {
	
	private String dir;
	
	private static final Logger logger = Logger.getLogger(RuntimeLauncher.class);

	/**
	 * Creates a launcher for a given template
	 * 
	 * @param template the template
	 * @param map simulation data
	 * @param dir the directory that contains launch configurations
	 */
	public RuntimeLauncher(ProcessDefinition template, Map<String, NodeSimulationConfig> map, String dir) {
		super(template, map);
		this.dir = dir;
	}

	/*
	 * {@inheritDoc}
	 */
	@Override
	public void startSimulation() {
		try {
			WorkflowProcess process = create(template, getInitialParameters(template.getStartState()));
			
			process.getContextInstance().setTransientVariable(CONFIG, configs);
			process.getContextInstance().setTransientVariable("__dir", dir);
		} catch (Exception e) {
			logger.error(":(", e);
		}
	}
	
	private Map<String, Object> getInitialParameters(Node node) {
		SimulationData sd = configs.get(node.getName()).getSimulationData();
		
		return new ParameterizableSimulationData(sd).getVariables();
	}
}
