/**
 * NodeFinder.java
 * Created Sep 5, 2012
 */
package com.tandbergtv.watchpoint.studio.debugger.runtime.debug;

import org.jbpm.graph.def.Node;

import com.tandbergtv.workflow.core.graph.NodeVisitor;

class NodeFinder implements NodeVisitor {
	
	private Node target;
	
	private String name;
	
	/**
	 * Creates a finder
	 * 
	 * @param name
	 */
	public NodeFinder(String name) {
		super();
		this.name = name;
	}

	/**
	 * Call this only after visit() completes
	 * 
	 * @return the target
	 */
	public Node getTarget() {
		return target;
	}

	/*
	 * {@inheritDoc}
	 */
	public void visit(Node node) {
		if (target != null)
			return; //Done
		
		if (name.equals(node.getName()))
			target = node;
	}
}