/**
 * ManualTaskHandler.java
 * Created Aug 23, 2012
 */
package com.tandbergtv.watchpoint.studio.debugger.runtime.exe;

import static com.tandbergtv.watchpoint.studio.debugger.launching.TemplateLauncherConstants.CONFIG;

import java.util.Map;

import org.jbpm.graph.def.ActionHandler;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.exe.ExecutionContext;

import com.tandbergtv.watchpoint.studio.debugger.model.NodeSimulationConfig;
import com.tandbergtv.watchpoint.studio.debugger.runtime.nodesimulation.NodeSimulator;
import com.tandbergtv.watchpoint.studio.debugger.runtime.nodesimulation.NodeSimulatorFactory;

/**
 * Forces a manual task to complete
 * 
 * @author Sahil Verma
 */
public class ManualTaskHandler implements ActionHandler {

	private static final long serialVersionUID = 1L;

	/*
	 * {@inheritDoc}
	 */
	@Override
	public void execute(ExecutionContext context) throws Exception {
		@SuppressWarnings("unchecked")
		Map<String, NodeSimulationConfig> map = 
			(Map<String, NodeSimulationConfig>) context.getContextInstance().getTransientVariable(CONFIG);
		Node node = context.getNode();
		NodeSimulator ns = new NodeSimulatorFactory(map).getSimulatorFor(node);
		
		/* Variables updated */
		ns.startSimulation(context);
		
		/* And we're done */
		node.leave(context);
	}
}
