/**
 * PreInsertEventListener.java
 * Created Mar 23, 2012
 */
package com.tandbergtv.watchpoint.studio.debugger.runtime.hibernate;

import java.lang.reflect.Field;
import java.util.Date;

import org.hibernate.HibernateException;
import org.hibernate.event.SaveOrUpdateEvent;

import com.tandbergtv.workflow.core.WorkflowTemplate;

/**
 * Adds the create date to the template
 * 
 * @author Sahil Verma
 */
public class SaveEventListener implements org.hibernate.event.SaveOrUpdateEventListener {

	private static final long serialVersionUID = 7253728166418003183L;

	public SaveEventListener() {
	}

	/*
	 * {@inheritDoc}
	 */
	@Override
	public void onSaveOrUpdate(SaveOrUpdateEvent e) throws HibernateException {
		Object o = e.getObject();
		Class<?> clazz = o.getClass();
		
		if (clazz == WorkflowTemplate.class) {
			try {
				Field field = clazz.getDeclaredField("createDate");
				
				field.setAccessible(true);
				field.set(o, new Date());
			} catch (Exception e1) {
				e1.printStackTrace();
			}
		}
	}
}
