package com.tandbergtv.watchpoint.studio.describer;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.CharBuffer;
import java.util.Hashtable;

import org.eclipse.core.internal.content.XMLContentDescriber;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.content.IContentDescriber;
import org.eclipse.core.runtime.content.IContentDescription;

/**
 * 		Content describer for JPF Extension points which analyzes the "point-id" attribute of the JPF's plugin.xml <extension> tag. 
 * 
 * @author <a href="francisco.neto@venturus.org.br">vntfrne Francisco Bento da Silva Neto</a>
 *
 */
public class JPFExtensionPointIDContentDescriber extends XMLContentDescriber implements IExecutableExtension {

	private static final String POINT_ID_XML_TAG = "point-id";
	private String filter;
	
	public int describe(InputStream input,
            			IContentDescription description) throws IOException {
		String xml = getXMLContent(input);
		
		if (xml.contains(filter)) {
			return IContentDescriber.VALID;
		} 
		
		return IContentDescriber.INVALID;
	}
	
	public String getXMLContent(InputStream input) throws IOException {
		Writer writer = new StringWriter();
		char[] buffer = new char[1024];
		int n;
		Reader reader = new BufferedReader(new InputStreamReader(input));
		while ((n = reader.read(buffer)) != -1) {
			writer.write(buffer, 0, n);
	    }
		return writer.toString();
	}
	
	public int describe(Reader input,
            			IContentDescription description) throws IOException {
		String xml = getXMLContent(input);
		
		if (xml.contains(filter)) {
			return IContentDescriber.VALID;
		} 
		
		return IContentDescriber.INVALID;
	}
	
	public String getXMLContent(Reader input) throws IOException {
		StringBuilder builder = new StringBuilder();
		CharBuffer buffer = CharBuffer.allocate(1024);
		input.read(buffer);
		builder.append(buffer.array());
		input.close();
		return builder.toString();
	}

	@SuppressWarnings("rawtypes")
	@Override
	public void setInitializationData(final IConfigurationElement config, final String propertyName, final Object data) throws CoreException {
		 if (data instanceof String ) {
			 filter = (String) data;
		 } else if (data instanceof Hashtable) {
			 Hashtable parameters = (Hashtable) data;
			 filter = (String) parameters.get("filter");
		 }
		 filter = POINT_ID_XML_TAG + "=\"" + filter + "\"";
	}
}
