/*
 * Created on Aug 23, 2007
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.watchpoint.studio.dto;

/**
 * A Configuration Parameter for a Resource Type. The Parameter may be used for Adaptor, HeartBeat
 * or Initialization configuration.
 * 
 * @author Vijay Silva
 */
public class ResourceTypeParameter implements IWatchPointDTO, IPersistable
{
	private static final long serialVersionUID = -7542065344349448127L;

	private long id = DEFAULT_ID;

	private ResourceType resourceType;

	private ParameterType type;

	private String name;

	private String value;

	/**
	 * Default Constructor
	 */
	public ResourceTypeParameter()
	{
	}

	/**
	 * Constructor
	 * 
	 * @param resourceType
	 *            The owning Resource Type
	 * @param parameterType
	 *            The Parameter Type
	 * @param name
	 *            The Parameter name
	 * @param value
	 *            The Parameter value
	 */
	public ResourceTypeParameter(ResourceType resourceType, ParameterType parameterType,
			String name, String value)
	{
		this.resourceType = resourceType;
		this.type = parameterType;
		this.name = name;
		this.value = value;
	}

	/**
	 * @see com.tandbergtv.watchpoint.studio.dto.IPersistable#getKey()
	 */
	public Long getKey()
	{
		return this.id;
	}

	/**
	 * Get the Parameter Id
	 * 
	 * @return The Parameter Id
	 */
	public long getId()
	{
		return this.id;
	}

	/**
	 * Set the Parameter Id
	 * 
	 * @param id
	 *            The Parameter Id
	 */
	public void setId(long id)
	{
		this.id = id;
	}

	/**
	 * @return the parameter name
	 */
	public String getName()
	{
		return this.name;
	}

	/**
	 * @param parameterName
	 *            the parameter name to set
	 */
	public void setName(String parameterName)
	{
		this.name = parameterName;
	}

	/**
	 * Get the Resource Type
	 * 
	 * @return The Resource Type
	 */
	public ResourceType getResourceType()
	{
		return this.resourceType;
	}

	/**
	 * Set the Resource Type
	 * 
	 * @param resourceType
	 *            The Resource Type
	 */
	public void setResourceType(ResourceType resourceType)
	{
		this.resourceType = resourceType;
	}

	/**
	 * Get the Parameter Type
	 * 
	 * @return The Parameter Type
	 */
	public ParameterType getType()
	{
		return this.type;
	}

	/**
	 * Set the Parameter Type
	 * 
	 * @param parameterType
	 *            The Parameter Type
	 */
	public void setType(ParameterType parameterType)
	{
		this.type = parameterType;
	}

	/**
	 * Get the Parameter Value
	 * 
	 * @return The value
	 */
	public String getValue()
	{
		return this.value;
	}

	/**
	 * Set the Parameter Value
	 * 
	 * @param value
	 *            The value
	 */
	public void setValue(String value)
	{
		this.value = value;
	}

	// ========================================================================
	// ================= OVERRIDEN METHODS
	// ========================================================================

	/**
	 * @see java.lang.Object#hashCode()
	 */
	@Override
	public int hashCode()
	{
		if (this.id == DEFAULT_ID)
			return super.hashCode();

		return new Long(this.id).hashCode() * 4 - 549;
	}

	/**
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	@Override
	public boolean equals(Object obj)
	{
		if (!(obj instanceof ResourceTypeParameter))
			return false;

		ResourceTypeParameter parameter = (ResourceTypeParameter) obj;

		/* Check for the Default Id */
		if (this.id == DEFAULT_ID && parameter.id == DEFAULT_ID)
			return super.equals(parameter);

		return (this.id == parameter.id);
	}

	/**
	 * @see java.lang.Object#clone()
	 */
	@Override
	public ResourceTypeParameter clone()
	{
		ResourceTypeParameter clone = null;

		try
		{
			clone = (ResourceTypeParameter) super.clone();
		}
		catch (CloneNotSupportedException ex)
		{ // Should never happen
		}

		return clone;
	}
}
