package com.tandbergtv.watchpoint.studio.external.jpf;

import org.apache.log4j.Logger;
import org.java.plugin.registry.Extension;
import org.java.plugin.registry.Extension.Parameter;

import com.tandbergtv.watchpoint.studio.external.jpf.model.ResourceGroupDescriptor;

/**
 * Parser class for Resource Group Plugin.
 * Converts Extension to Resource Group Descriptor entity.
 * 
 * @author rprakash
 *
 */
public class ResourceGroupExtensionParser {

	private static final Logger logger = Logger.getLogger(ResourceGroupExtensionParser.class);
	
	private ResourceGroupExtensionParser()
	{
	}
	
	public static ResourceGroupDescriptor parse(Extension extension, ClassLoader classLoader)
	{
		//if the parameter is defined (not null) and trimmed rawValue length > 0, then there is some value.
		//it may be invalid. but, it is taken care by validation 
		
		//if the value for a parameter is empty or contains just spaces,
		//then, it is assumed null & the parameter value set to null
		
		logger.debug("Entering method...");
		ResourceGroupDescriptor descriptor = new ResourceGroupDescriptor();

		descriptor.setExtensionId(extension.getId());
		
		descriptor.setPluginId(extension.getDeclaringPluginDescriptor().getId());

		Parameter param = extension.getParameter(PluginParameters.SYSTEM_ID);
		if(param != null && param.rawValue().trim().length() > 0)
			descriptor.setSystemId(param.valueAsString());

		param = extension.getParameter(PluginParameters.NAME);
		if(param != null && param.rawValue().trim().length() > 0)
			descriptor.setName(param.valueAsString());

		param = extension.getParameter(PluginParameters.DESCRIPTION);
		if(param != null && param.rawValue().trim().length() > 0)
			descriptor.setDescription(param.valueAsString());

		param = extension.getParameter(PluginParameters.RG_IS_INTERNALLY_ACQUIRED);
		if(param != null && param.rawValue().trim().length() > 0)
			descriptor.setIsInternallyAcquired(param.valueAsBoolean());
		
		param = extension.getParameter(PluginParameters.RG_ALLOCATION_STRATEGY_CLASS);
		if(param != null && param.rawValue().trim().length() > 0)
			descriptor.setAllocationStrategyClass(param.valueAsString());
		
		param = extension.getParameter(PluginParameters.RG_ACCESS_LEVEL);
		if(param != null && param.rawValue().trim().length() > 0)
			descriptor.setAccessLevel(param.valueAsString());
		
		param = extension.getParameter(PluginParameters.RG_FUNCTIONAL_TYPE);
		if(param != null && param.rawValue().trim().length() > 0)
			descriptor.setFunctionalType(param.valueAsString());
		
		param = extension.getParameter(PluginParameters.RG_IMAGE_PATH);
		if(param != null && param.rawValue().trim().length() > 0)
			descriptor.setImagePath(param.valueAsString());

		int version = extension.getDeclaringPluginDescriptor().getVersion().getMajor();
		descriptor.setVersion(version);
		
		descriptor.setClassLoader(classLoader);
		
		return descriptor;
	}
}
